Name: fritzing
Version: 0.9.3b.0.31.git701e3a3
Release: alt5

Summary: Intuitive EDA platform featuring from prototype to product
License: GPLv3, CC-BY-SA-3.0
Group: Engineering

Url: http://fritzing.org
# https://github.com/fritzing/fritzing-app
Source0: %name-%version.tar
# https://github.com/fritzing/fritzing-parts
Source1: %name-parts.tar

Patch: fritzing-desktop-file-translation.patch

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires: boost-devel-headers desktop-file-utils gcc-c++ glibc-devel-static
BuildRequires: phonon-devel rpm-build-python3 rpmbuild-helper-desktop
BuildRequires: rpmbuild-helper-sugar-activity ruby ruby-stdlibs
BuildRequires: libgit2-devel qt5-base-devel qt5-svg-devel qt5-serialport-devel

# large chunk of arch-independent data is better not duplicated
Requires: %name-data = %EVR

%description
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

%package data
Summary: Data files for %name
License: GPLv3
Group: Engineering
BuildArch: noarch

%description data
Fritzing is an open-source initiative to support designers, artists,
researchers and hobbyists to take the step from physical prototyping
to actual product. It is in the spirit of Processing and Arduino which
allows users to document their Arduino and other electronic-based
prototypes, and to create a PCB layout for manufacturing.

This package contains shared data files for Fritzing.

%prep
%setup -a1
%patch -p1
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
qmake-qt5
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot
cp -r %name-parts %buildroot/%_datadir/%name

%files
%doc LICENSE.*
%_bindir/Fritzing
%_iconsdir/%name.png
%_desktopdir/fritzing.desktop
%_man1dir/Fritzing.*
%_datadir/mime/packages/%name.xml

%files data
%_datadir/%name

%changelog
