%define        pkgname cairo

Name:          gem-%pkgname
Version:       1.16.5
Release:       alt1
Summary:       ruby bindings for cairo
Group:         Development/Ruby
License:       GPLv2
Url:           https://rcairo.github.io/
Vcs:           https://github.com/rcairo/rcairo.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libcairo-devel
BuildRequires: glib2-devel
BuildRequires: libpixman-devel
BuildRequires: xorg-glproto-devel
BuildRequires: xorg-dri2proto-devel
BuildRequires: libXau-devel
BuildRequires: libXdmcp-devel
BuildRequires: libXext-devel
BuildRequires: libXdamage-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libpcre-devel
BuildRequires: libuuid-devel
BuildRequires: libffi-devel
BuildRequires: bzlib-devel
BuildRequires: libossp-uuid-dce-devel
BuildRequires: libdrm-devel
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(xshmfence)
BuildRequires: gem(native-package-installer) >= 1.0.3
BuildRequires: gem(pkg-config) >= 1.2.2

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-r%pkgname
Provides:      ruby-r%pkgname
Provides:      rcairo = %version-%release
Obsoletes:     rcairo < 1.7.0

%description
Ruby bindings for cairo // cairo extension for Ruby.


%package       devel
Summary:       Development files for %name
Group:         Development/Ruby
BuildArch:     noarch

Obsoletes:     rcairo-devel < 1.7.0
Provides:      rcairo-devel = %version-%release
Requires:      libcairo-devel
Requires:      glib2-devel
Requires:      libpixman-devel
Requires:      xorg-glproto-devel
Requires:      xorg-dri2proto-devel
Requires:      libXau-devel
Requires:      libXdmcp-devel
Requires:      libXext-devel
Requires:      libXdamage-devel
Requires:      libXxf86vm-devel
Requires:      libpcre-devel
Requires:      libuuid-devel
Requires:      libffi-devel
Requires:      bzlib-devel
Requires:      libossp-uuid-dce-devel
Requires:      libdrm-devel
Requires:      pkgconfig(expat)
Requires:      pkgconfig(harfbuzz)
Requires:      pkgconfig(xshmfence)
Requires:      gem(native-package-installer) >= 1.0.3
Requires:      gem(pkg-config) >= 1.2.2

%description   devel
Ruby bindings for cairo // cairo extension for Ruby.

This package contains development files for%gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         devel
%ruby_includedir/*

%files         doc
%ruby_gemdocdir

%changelog
