%define        pkgname nokogiri

Name:          gem-%pkgname
Version:       1.11.0
Release:       alt0.0.1
Summary:       Ruby libraries for Nokogiri (HTML, XML, SAX, and Reader parser)
Group:         Development/Ruby
License:       MIT
Url:           https://nokogiri.org/
Vcs:           https://github.com/sparklemotion/nokogiri.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
Patch:         shutdown-libxml2-warning.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: libxml2-devel libxslt-devel ruby-pkg-config zlib-devel
BuildRequires: gem-hoe
BuildRequires: gem(rake-compiler)
BuildRequires: gem(rake-compiler-dock)
BuildRequires: gem(concourse)
BuildRequires: gem(rexical)
BuildRequires: gem-racc
BuildRequires: gem-minitest
BuildRequires: gem(mini_portile2)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
Nokogiri parses and searches XML/HTML very quickly, and also has correctly
implemented CSS3 selector support as well as XPath support.
This package contanis Ruby libraries for Nokogiri.

%package       -n %pkgname
Summary:       HTML, XML, SAX, and Reader parser
Group:         Development/Other
BuildArch:     noarch

%description   -n %pkgname
Nokogiri parses and searches XML/HTML very quickly, and also has correctly
implemented CSS3 selector support as well as XPath support.
This package contanis Ruby libraries for Nokogiri.

Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       devel
Summary:       Development files for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Requires:      libxml2-devel
Requires:      libxslt-devel
Requires:      java-devel
Requires:      ruby-pkg-config
Requires:      zlib-devel

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%prep
%setup
find /usr/lib/ruby -name "test_task*"
gem list

%build
%ruby_build --use=%gemname --version-replace=%version

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n %pkgname
%_bindir/*

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*

%changelog
