%define        pkgname ovirt-engine-sdk

Name:          gem-%pkgname
Version:       4.3.0
Release:       alt2
Summary:       The oVirt Ruby SDK is a Ruby gem that simplyfies access to the oVirt Engine API
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://github.com/oVirt/ovirt-engine-sdk-ruby
Vcs:           https://github.com/oVirt/ovirt-engine-sdk-ruby.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: xmllint
BuildRequires: libcurl-devel
BuildRequires: libxml2-devel
BuildRequires: gem(rake)
BuildRequires: gem(rake-compiler)
BuildRequires: gem(rubocop)
BuildRequires: gem(yard)
BuildRequires: gem(rspec-core)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
%summary.

This is a mirror from gerrit.ovirt.org http://www.ovirt.org, for issues use http://bugzilla.redhat.com


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       devel
Summary:       Development files for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Requires:      xmllint
Requires:      libcurl-devel
Requires:      libxml2-devel

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%prep
%setup
# NOTE: create version.rb
echo "module OvirtSDK4;VERSION = '$(xmllint pom.xml --xpath "/*[name()='project']/*[name()='version']/text()")';end" > sdk/lib/ovirtsdk4/version.rb

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*


%changelog
