%define        pkgname rake

Name:          gem-%pkgname
Version:       13.0.1
Release:       alt1
Summary:       Ruby based make-like utility
Summary(ru_RU.UTF-8): Make-подобная утилита для рубина
License:       MIT
Group:         Development/Ruby
Url:           https://ruby.github.io/rake/
Vcs:           https://github.com/ruby/rake.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(bundler)
BuildRequires: gem(minitest)
BuildRequires: gem(rdoc)
BuildRequires: gem(coveralls)
BuildRequires: gem(rubocop)

%add_findreq_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
Rake is a Make-like program implemented in Ruby. Tasks and dependencies
are specified in standard Ruby syntax.

%description -l ru_RU.UTF-8
Rake есть Make-подобная утилита и набор модулей, исполненные на рубине.
Задачи и зависимости описываются в рядовом правописании рубина.


%package       -n %pkgname
Summary:       Executable file for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

%description   -n %pkgname
Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Исполнямка для %gemname самоцвета


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=%gemname --version-replace=%version

%install
%ruby_install

%check
%rake_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%files         -n %pkgname
%_bindir/%pkgname
%_mandir/*


%changelog
