# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname redcloth
%define        gemname RedCloth

Name:          gem-%pkgname
Version:       4.3.2
Release:       alt3
Summary:       Textile parser for Ruby
Group:         Development/Ruby
License:       MIT
Url:           https://redcloth.org/
Vcs:           https://github.com/jgarber/redcloth.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
Source:        %name-%version.tar
BuildArch:     noarch

BuildRequires(pre): rpm-build-ruby

%add_findreq_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname
Provides:      ruby-%pkgname

%description
RedCloth is a module for using Textile in Ruby. Textile is a text format.
A very simple text format. Another stab at making readable text that can
be converted to HTML.


%package       -n %pkgname
Summary:       Executable file for %gemname gem
Summary(ru_RU.UTF-8): Исполнямка для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n %pkgname
Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       devel
Summary:       Development files for %gemname gem
Summary(ru_RU.UTF-8): Файлы разработки для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы разработки для самоцвета %gemname.

%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=RedCloth --alias=redcloth

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*

%files         -n %pkgname
%_bindir/%pkgname


%changelog
