%define        pkgname sqlite3

Name:          gem-%pkgname
Version:       1.4.2
Release:       alt2
Summary:       A Ruby interface for the SQLite database engine
Group:         Development/Ruby
License:       BSD
Url:           https://github.com/sparklemotion/sqlite3-ruby
Vcs:           https://github.com/sparklemotion/sqlite3-ruby.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libsqlite3-devel
BuildRequires: gem(rake-compiler)
BuildRequires: gem(mini_portile2)
BuildRequires: gem(hoe)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     %pkgname-ruby < %EVR
Provides:      %pkgname-ruby = %EVR

%description
A Ruby interface for the SQLite database engine.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       devel
Summary:       Development files for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Requires:      libsqlite3-devel

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=%gemname --version-replace=%version

%install
%ruby_install

%check
%ruby_test

%files
%doc CHANGELOG* README*
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         devel
%ruby_includedir/*

%files         doc
%ruby_gemdocdir

%changelog
