# Since version 3.0, the Python bindings are unsupported by upstream.
# See also http://trac.osgeo.org/geos/ticket/228
%def_without python
%def_without python3
# TODO: tests are failed
%def_without tests

Name: geos
Version: 3.9.1
Release: alt1

Summary: Geometry Engine - Open Source
License: LGPL-2.1
Group: Sciences/Geosciences
Url: http://trac.osgeo.org/geos/

Packager: Andrey Cherepanov <cas@altlinux.org>

# VCS: https://git.osgeo.org/gogs/geos/geos.git
Source: %name-%version.tar
Patch1: %name-fix-lib-destination.patch
Patch2: %name-alt-fix-link-benchmarks.patch
Patch3: %name-fix-geos-config--libs.patch

BuildRequires(pre): rpm-build-ruby
BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++ python-devel swig
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif
# For tests
%if_with tests
BuildRequires: ctest
%endif

%description
GEOS (Geometry Engine - Open Source) is a C++ port of the Java
Topology Suite (JTS). As such, it aims to contain the complete
functionality of JTS in C++. This includes all the OpenGIS
"Simple Features for SQL" spatial predicate functions and
spatial operators, as well as specific JTS topology functions
such as IsValid().

%package -n lib%name
Summary: Geometry Engine - Open Source
Group: Sciences/Geosciences
Provides:  libgeos1 = %EVR
Obsoletes: libgeos1 < %EVR

%description -n lib%name
GEOS (Geometry Engine - Open Source) is a C++ port of the Java
Topology Suite (JTS). As such, it aims to contain the complete
functionality of JTS in C++. This includes all the OpenGIS
"Simple Features for SQL" spatial predicate functions and
spatial operators, as well as specific JTS topology functions
such as IsValid().

%package -n lib%name-devel
Summary: Development files for the Geometry Engine - Open Source
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files for the Geometry Engine - Open Source

%if_with python
%package -n python-module-%name
Summary: Python bindings for the lib%name library
Group: Development/Python
Requires: lib%name = %version-%release

%description -n python-module-%name
Python bindings for the lib%name library.
%endif

%if_with python3
%package -n python3-module-%name
Summary: Python bindings for the lib%name library
Group: Development/Python3
Requires: lib%name = %version-%release

%description -n python3-module-%name
Python bindings for the lib%name library.
%endif

%package -n ruby-%name
Summary: Ruby bindings for the lib%name library
Group: Development/Ruby
Requires: lib%name = %version-%release

%description -n ruby-%name
Ruby bindings for the lib%name library.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%ifarch %e2k
# strip UTF-8 BOM
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
# lcc 1.23.12 doesn't support this option yet
sed -i 's, -fno-implicit-inline-templates,,' CMakeLists.txt
%endif

%if_with python3
cp -fR . ../python3
%endif

%build
./autogen.sh
%undefine _configure_gettext
%configure \
	--disable-static \
%if_with python
	--enable-python \
%else
	--disable-python \
%endif
	--disable-ruby

%if_with python3
pushd ../python3
sed -i 's|\(\-python\)|\1 -py3|' macros/ac_pkg_swig.m4
sed -i 's|python\$PYTHON_VERSION|python\${PYTHON_VERSION}m|' \
	macros/ac_python_devel.m4
export PYTHON=/usr/bin/python3
./autogen.sh
%configure \
	--disable-static \
	--enable-python \
	--disable-ruby
export PYTHON=
popd
%endif

%if %_lib == lib64
LIB_SUFFIX=64
%endif

# E2K: tests/unit/tut/tut.hpp: excessive recursion at instantiation [...]
%cmake_insource -GNinja \
	-DGEOS_BUILD_STATIC:BOOL=OFF \
%ifarch armh
	-DDISABLE_GEOS_INLINE=ON \
%endif
%ifarch %e2k
	-DGEOS_ENABLE_TESTS:BOOL=OFF \
%endif
	#
%ninja_build

%if_with python
%make -C swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

%if_with python3
%make -C ../python3/swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

%install
%ninja_install

%if %_lib == lib64
LIB_SUFFIX=64
%endif

%if_with python
%makeinstall_std -C swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
%endif

rm -f %buildroot%python_sitelibdir/geos/*.la
rm -f %buildroot%ruby_sitearchdir/*.la

%if_with python3
%makeinstall_std -C ../python3/swig/python LIB_SUFFIX=$LIB_SUFFIX \
	ENABLE_PYTHON=1 ENABLE_SWIG=1
rm -f %buildroot%python3_sitelibdir/geos/*.la
%endif

%if_with tests
%check
%ninja_build check || exit 0
%endif

%files -n lib%name
%doc AUTHORS NEWS README.md
%_libdir/lib*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_libdir/libgeos.so
%_libdir/libgeos_c.so
%_includedir/*
%_libdir/cmake/GEOS
%_libdir/pkgconfig/geos.pc

%if_with python
%files -n python-module-%name
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-%name
%python3_sitelibdir/*
%endif

%if 0
%files -n ruby-%name
%ruby_sitearchdir/*
%endif

%changelog
