
%define sover 5
%define libgetfem libgetfem%sover
%add_python3_req_skip _getfem

%define rname getfem
Name: getfemxx
Version: 5.3
Release: alt1

Group: Development/C++
Summary: Generic and efficient C++ library for finite element methods
Url: http://getfem.org/
License: LGPLv2+

Provides: %rname = %version-%release
Obsoletes: %rname < %version-%release

Source0: getfem-%version.tar
Patch1: alt-ppc64le.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-devel gcc-c++ gcc-fortran glibc-devel-static libnumpy-devel
BuildRequires: python3-module-scipy-devel python3-module-mpi4py-devel
%ifnarch %{arm} aarch64 ppc64le
BuildRequires: scilab
%endif

BuildPreReq: libqhull-devel libmuparser-devel libmumps-devel
BuildPreReq: liblapack-devel
#libsuperlu-devel

%description
The Getfem++ project focuses on the development of a generic and
efficient C++ library for finite element methods. The goal is to provide
a library allowing the computation of any elementary matrix (even for
mixed finite element methods) on the largest class of methods and
elements, and for arbitrary dimension (i.e. not only 2D and 3D
problems).

%package -n %libgetfem
Group: System/Libraries
Summary: %rname library
Provides: libgetfemxx = %version-%release
Obsoletes: libgetfemxx < %version-%release
%description -n %libgetfem
%rname library

%package -n python3-module-getfem
Summary: Python bindings to %name
Group: Development/Python
%description -n python3-module-getfem
Python bindings to %name


%prep
%setup -q -n %rname-%version
%patch1 -p1
%autoreconf

%build
%add_optflags -fno-strict-aliasing -fpermissive -I%_includedir/metis0
export CFLAGS="%optflags" CXXFLAGS="%optflags"
%undefine _configure_gettext
%configure \
	--disable-static \
	--enable-shared \
	--enable-boost \
	--enable-mumps \
	--with-mumps="dmumps zmumps smumps cmumps mumps_common pord" \
	--enable-qhull \
	--with-blas=openblas \
	--with-pic \
	--with-matlab-toolbox-dir=%_datadir/getfem_toolbox \
	--enable-python3 \
	#
CUT_CFLAGS=`grep "^CXXFLAGS" Makefile | head -n 1| sed "s|^CXXFLAGS[[:space:]][[:space:]]*=||"`
%make_build CFLAGS="$CUT_CFLAGS"

%install
%makeinstall_std

%if "%python3_sitelibdir_noarch/getfem" != "%python3_sitelibdir/getfem"
mv %buildroot/%python3_sitelibdir_noarch/getfem/* \
	%buildroot/%python3_sitelibdir/getfem/
%endif

mkdir -p %buildroot/%__python3_dynlibdir
install -m 0644 \
    interface/src/python/_getfem.cpython*.so \
    %buildroot/%python3_sitelibdir/

%files
%doc NEWS AUTHORS
%_datadir/getfem_toolbox
%_bindir/getfem-config
%_includedir/getfem
%_includedir/getfem_boost
%_includedir/gmm
%_libdir/*.so

%files -n %libgetfem
%_libdir/*.so.*

%files -n python3-module-getfem
%python3_sitelibdir/getfem
%python3_sitelibdir/*getfem*.so

%changelog
