Name: gettext
Version: 0.20.2
Release: alt1

%define libintl libintl3

Summary: GNU libraries and utilities for producing multi-lingual messages
License: GPLv3+ and LGPLv2.1+ and GFDL-1.2+
Group: System/Base
Url: https://www.gnu.org/software/gettext/

# https://ftp.gnu.org/gnu/gettext/gettext-%version.tar.xz
Source: gettext-%version.tar
Source1: msghack.py
Source2: msghack.1
Source3: gettext-po-mode-start.el

Patch10: gettext-alt-autogen.patch
Patch11: gettext-alt-gettextize-quiet.patch
Patch12: gettext-alt-autopoint-archive.patch
Patch13: gettext-alt-tmp-autopoint.patch
Patch14: gettext-alt-gcc.patch
Patch15: gettext-alt-urlview.patch
Patch16: gettext-alt-libtextstyle.patch

Provides: %name-base = %version-%release
Obsoletes: %name-base

%def_disable static
%def_without included_gettext
%def_without java
%def_with emacs

%{?_with_included_gettext:Requires: %libintl = %version-%release}
BuildPreReq: gcc-c++ makeinfo xz %{?_with_java:jdkgcj /proc} %{?_with_emacs:emacs-nox}
# Needed for the --color option of the various programs.
# Otherwise, embedded versions are used, which is forbidden by policy.
BuildRequires: glib2-devel libcroco-devel libncurses-devel libunistring-devel libxml2-devel
# Needed for the test suite.
%{?!_without_check:%{?!_disable_check:BuildRequires: python-modules}}

%package -n %libintl
Summary: The dynamic %libintl library for the gettext package
License: LGPLv2+
Group: System/Libraries
Provides: libintl = %version-%release
Obsoletes: libintl

%package -n %libintl-devel
Summary: Development library for %libintl
License: LGPLv2+
Group: Development/C
Requires: %libintl = %version-%release
Provides: libintl-devel = %version-%release
Obsoletes: libintl-devel

%package -n %libintl-devel-static
Summary: Development static library for %libintl
License: LGPLv2+
Group: Development/C
Requires: %libintl-devel = %version-%release
Provides: libintl-devel-static = %version-%release
Obsoletes: libintl-devel-static

%package tools
Summary: Tools and documentation for developers and translators
License: GPLv3+
Group: Development/Other
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Requires: %name = %version-%release
Requires: mktemp >= 1:1.3.1
%define lib_suffix %{?_is_libsuff:()(%{_libsuff}bit)}
%{!?_with_included_gettext:Provides: preloadable_libintl.so%lib_suffix}

%package tools-java
Summary: Tools for java developers and translators
License: GPLv3+
Group: Development/Other
Requires: %name-tools = %version-%release

%package tools-python
Summary: Python tools for developers and translators
License: GPLv2+
Group: Development/Other
BuildArch: noarch
Requires: %name-tools = %version-%release

%package doc
Summary: The GNU gettext manual
License: GPLv2+ or GFDL-1.2+
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%package -n libasprintf
Summary: Formatted output to strings in C++
License: LGPLv2+
Group: Development/C++

%package -n libasprintf-devel
Summary: Development related files for libasprintf
License: LGPLv2+
Group: Development/C++
Requires: libasprintf = %version-%release

%package -n libtextstyle
Summary: A text styling library
License: GPLv3+
Group: Development/C++

%package -n libtextstyle-devel
Summary: Development related files for libtextstyle
License: GPLv3+
Group: Development/C++
Requires: libtextstyle = %version-%release

%description
The GNU gettext provides a set of tools and documentation for producing
multi-lingual messages in programs.  Tools include a set of conventions about
how programs should be written to support message catalogs, a directory and
file naming organization for the message catalogs, a runtime library which
supports the retrieval of translated messages, and stand-alone programs for
handling the translatable and the already translated strings.  Gettext provides
an easy to use library and tools for creating, using, and modifying natural
language catalogs and is a powerful and simple method for internationalizing
programs.

This package contains gettext and ngettext utilities.

If you would like to internationalize or incorporate multi-lingual messages
into programs that you're developing, you should install %name-tools.

%description -n %libintl
This package contains the dynamic %libintl library.

%description -n %libintl-devel
This package contains development %libintl library.

%description -n %libintl-devel-static
This package contains static %libintl library.

%description tools
The GNU gettext provides a set of tools and documentation for producing
multi-lingual messages in programs.  Tools include a set of conventions about
how programs should be written to support message catalogs, a directory and
file naming organization for the message catalogs, a runtime library which
supports the retrieval of translated messages, and stand-alone programs for
handling the translatable and the already translated strings.  Gettext provides
an easy to use library and tools for creating, using, and modifying natural
language catalogs and is a powerful and simple method for internationalizing
programs.

If you would like to internationalize or incorporate multi-lingual messages
into programs that you're developing, you should install this package.

%description tools-java
This package adds java support to %name-tools.

%description tools-python
This package contains msghack utility.

%description doc
GNU gettext offers to programmers, translators and even users, a well
integrated set of tools and documentation that provides a framework within
which other free packages may produce multi-lingual messages.

This manual documents GNU gettext.

%description -n libasprintf
This package makes the C formatted output routines (fprintf et al.)
usable in C++ programs, for use with the <string> strings and the
<iostream> streams.

%description -n libasprintf-devel
This packages contains development files for libasprintf,
a formatted output library for C++.

%description -n libtextstyle
The GNU libtextstyle is a text styling library that provides an easy way
to add styling to programs that produce output to a console or terminal
emulator window.

%description -n libtextstyle-devel
This packages contains all development related files for the GNU libtextstyle,
a text styling library.

%prep
%setup
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

# Comment out sys_lib_search_path_spec and sys_lib_dlsearch_path_spec.
mkdir archive
cd archive
archive=../gettext-tools/misc/archive.dir.tar
tar -xf $archive
find -type f -print0 |
	xargs -r0 grep -lZ '\<sys_lib_\(dl\)\?search_path_spec=' -- |
	xargs -r0 sed -i 's/\<sys_lib_\(dl\)\?search_path_spec=/#&/' --
tar --owner=root --group=root -cf $archive *
cd -
rm -rf archive

# Regenerate texinfo documentation.
find -type f -name '*.info*' -delete

# Guard against libtextstyle attempt to bundle libcroco and libxml2.
# The comments indicate this is done because the libtextstyle authors do
# not want applications using their code to suffer startup delays due to
# the relocations in these libraries.  This is not an acceptable reason.
rm -r libtextstyle/gnulib-local/lib/lib* libtextstyle/lib/lib{croco,xml}

%build
%if_with java
if [ ! -f /proc/self/maps ]; then
	echo 'java support is enabled, but /proc/self/maps is not available'
	exit 1
fi
%endif
./autogen.sh --skip-gnulib
%add_optflags -fno-strict-aliasing
%configure --enable-shared \
	--without-included-regex \
	--without-included-glib \
	--without-included-libcroco \
	--without-included-libxml \
	--disable-csharp \
	--without-cvs --without-git \
	%{subst_with emacs} \
	%{subst_enable static} \
	%{?_with_included_gettext:--with-included-gettext} \
	#
# We have to edit libtool files by hand until autoreconf can be used here.
find -type f -name libtool -print0 |
	xargs -r0 grep -lZ '^sys_lib_dlsearch_path_spec="' -- |
	xargs -r0 sed -i 's|^\(sys_lib_dlsearch_path_spec="\).*|\1/%_lib %_libdir"|' --
%make_build

%install
%makeinstall_std \
	lispdir=%_datadir/emacs/site-lisp \
	aclocaldir=%_datadir/aclocal \
	#

install -pD -m755 %_sourcedir/msghack.py \
	%buildroot%_bindir/msghack
install -pm644 %_sourcedir/msghack.1 %buildroot%_man1dir/
install -pD -m644 %_sourcedir/gettext-po-mode-start.el \
	%buildroot%_sysconfdir/emacs/site-start.d/gettext.el

%if_with included_gettext
mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo libintl >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%libintl
#if_enabled static
echo libintl-devel >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%libintl-devel
echo libintl-devel-static >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%libintl-devel-static
#endif #enabled static
chmod 644 %buildroot%_sysconfdir/buildreqs/packages/substitute.d/*
%endif #with included_gettext
mkdir -p %buildroot%_docdir
%define docdir %_docdir/gettext

%find_lang %name-runtime
%find_lang %name-tools

%check
%make_build -k check VERBOSE=1

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%if_with included_gettext
%files -n %libintl
%config %_sysconfdir/buildreqs/packages/substitute.d/%libintl
%_libdir/libintl*.so.*

#if_enabled static
%files -n %libintl-devel
%config %_sysconfdir/buildreqs/packages/substitute.d/%libintl-devel
%_libdir/libintl*.so

%files -n %libintl-devel-static
%config %_sysconfdir/buildreqs/packages/substitute.d/%libintl-devel-static
%_libdir/libintl*.a
#endif #enabled static
%endif #with included_gettext

%files -f %name-runtime.lang
%_bindir/gettext
%_bindir/ngettext
%_bindir/envsubst
%_bindir/gettext.sh
%_man1dir/gettext.*
%_man1dir/ngettext.*
%_man1dir/envsubst.*

%files tools -f %name-tools.lang
%_libdir/gettext
%{?_with_java:%exclude %_libdir/gettext/gnu.gettext.*}
%_libdir/lib%{name}*.so*
%{!?_with_included_gettext:%_libdir/preloadable_libintl.so}
%_bindir/*
%exclude %_bindir/gettext
%exclude %_bindir/ngettext
%exclude %_bindir/envsubst
%exclude %_bindir/gettext.sh
%exclude %_bindir/msghack
%_includedir/%{name}*
%_mandir/man?/*
%exclude %_man1dir/gettext.*
%exclude %_man1dir/ngettext.*
%exclude %_man1dir/envsubst.*
%exclude %_man1dir/msghack.*
%_infodir/gettext.info*
%_datadir/gettext/
%_datadir/gettext-*/
%{?_with_java:%exclude %_datadir/gettext/libintl.jar}
%_datadir/aclocal/*
%if_with emacs
%_datadir/emacs/site-lisp/*.el*
%config(noreplace) %_sysconfdir/emacs/site-start.d/*.el
%endif
%dir %docdir
%docdir/FAQ.html
%docdir/tutorial.html

%files doc
%docdir
%exclude %docdir/FAQ.html
%exclude %docdir/tutorial.html

%if_with java
%files tools-java
%dir %_libdir/gettext
%_libdir/gettext/gnu.gettext.*
%dir %_datadir/gettext
%_datadir/gettext/libintl.jar
%endif

%files tools-python
%_bindir/msghack
%_man1dir/msghack.*

%files -n libasprintf
%_libdir/libasprintf.so.*

%files -n libasprintf-devel
%_includedir/autosprintf.h
%_libdir/libasprintf.so
%_infodir/autosprintf.info*
%_defaultdocdir/libasprintf

%files -n libtextstyle
%_libdir/libtextstyle.so.*

%files -n libtextstyle-devel
%_includedir/textstyle*
%_libdir/libtextstyle.so
%_infodir/libtextstyle.info*
%_defaultdocdir/libtextstyle/

%changelog
