%def_with tools
%define _unpackaged_files_terminate_build 1
%define mansuff xz
#set_compress_method none
%set_compress_method %mansuff
Name: girar-nmu
Version: 2.013.0
Release: alt1

Summary: girar client utilities for NMU automation
License: GPL-2.0-or-later
Group: Development/Other
Packager: Igor Vlasenko <viy@altlinux.org>
Url: http://www.altlinux.org/Git.alt/girar-nmu
#BuildArch: noarch

%if_with tools
Requires: girar-tools = %EVR
%endif

Source: %name-%version.tar

#BuildRequires: help2man
BuildRequires: m4
BuildRequires: perl-devel perl-podlators perl(RPM/Header.pm) perl-RPM-Source-Editor perl-RPM-Source-Convert perl(Pod/Usage.pm) perl(Date/Parse.pm) /usr/bin/pod2man perl-Gear-Rules perl(Source/Shared/Utils/GlobList.pm) perl(Source/Repository/RPM/ALTLinuxSrcList.pm) perl(Source/Shared/FindMirror/ALTLinux.pm) perl(ALTLinux/RepoList.pm)

Requires: gear
Requires: perl-RPM-Source-Editor >= 0.9233

%description
This package contains girar utilities for NMU automation.

%package -n  girar-tools
Summary: girar client tools for easy girar upload
Group: Development/Other
BuildArch: noarch
Conflicts: girar-nmu < 2

%description -n girar-tools
This package contains useful client utilities for girar and gitery
to guery upload methods, clone gits from tasks and gitery
and to help upload and manage tasks.

%prep
%setup
rm *.spec

%build
%make VERSION=%version
gcc -O2 %optflags -o girar-nmu-helper-pos-sort pos-sort.c

%install
%makeinstall_std

mkdir -p %buildroot%perl_vendor_privlib/RPM/Source/Transformation/
cp -a lib/RPM/Source/Transformation/* %buildroot%perl_vendor_privlib/RPM/Source/Transformation/

mkdir -p %buildroot%_sysconfdir/%name/
install -m 644 config/* %buildroot%_sysconfdir/%name/

mkdir -p %buildroot%_bindir/
install -m 755 girar-* rpm-sign-* srpmlschangelog %buildroot%_bindir/

for i in girar-* srpmlschangelog dist/girar-*; do
    name=`basename $i`
    pod2man  --name $name --center 'girar-nmu utils' --section 1 --release %version $i > $name.1 ||:
done
find . -name '*.1' -size 0 -print -delete
mkdir -p %buildroot%_man1dir
install -m 644 *.1 %buildroot%_man1dir/

while read link script; do
    ln -s $link %buildroot%_bindir/$script
    ln -s $link.1.%mansuff %buildroot%_man1dir/$script.1.%mansuff
done << 'EOF'
girar-task-add-git	girar-task-for-each-git
girar-task-add-git	girar-build-git
girar-task-add-srpm	girar-task-for-each-srpm
girar-task-add-srpm	girar-build-srpm
girar-task-add-rebuild girar-task-add-del
girar-task-add-rebuild girar-task-add-copy
girar-task-add-rebuild girar-task-for-each-rebuild
girar-task-add-rebuild girar-task-for-each-del
girar-task-add-rebuild girar-task-for-each-copy
girar-task-add-rebuild girar-build-rebuild
girar-task-add-rebuild girar-build-del
girar-task-add-rebuild girar-build-copy
EOF

%files
%doc README
%perl_vendor_privlib/RPM*
%_bindir/srpmlschangelog*
%_man1dir/srpmlschangelog*
%_bindir/girar-nmu-*
%_man1dir/girar-nmu-*

%if_with tools
%files -n girar-tools
%exclude %_bindir/girar-nmu-*
%exclude %_man1dir/girar-nmu-*
%endif

%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/default
%config(noreplace) %_sysconfdir/%name/e2k
%_bindir/rpm-sign-*
%_bindir/girar-*
%_man1dir/girar-*

%changelog
