%def_disable snapshot

%define ver_major 2.60
%define _libexecdir %_prefix/libexec
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

# Only one TLS or SSL can be enabled
%def_enable tls
%def_disable ssl

%def_enable libproxy
%def_enable gnome_proxy
%def_enable installed_tests
%def_disable check

Name: glib-networking
Version: %ver_major.3
Release: alt1.p9.2

Summary: Networking support for GIO
Group: System/Libraries
License: LGPLv2+
Url: http://www.gnome.org

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch1: glib-networking-2.60.3-upstream-alt-fix-cve-2020-13645.patch
Patch2: glib-networking-2.60.3-alt-fix-null-dereference.patch

%{?_enable_gnome_proxy:Requires: gsettings-desktop-schemas >= 3.2.0}
Requires: ca-certificates

%define glib_ver 2.56.1
%define gnutls_ver 2.12.8
%define p11kit_ver 0.20
%define libproxy_ver 0.3.1

BuildRequires(pre): meson
BuildRequires: libgio-devel >= %glib_ver libsystemd-devel
%{?_enable_ssl:BuildRequires: libssl-devel}
%{?_enable_gnome_proxy:BuildRequires: gsettings-desktop-schemas-devel}
%{?_enable_tls:BuildRequires: libgnutls-devel >= %gnutls_ver libgcrypt-devel}
%{?_enable_pkcs11:BuildRequires: libp11-kit-devel >= %p11kit_ver ca-certificates}
%{?_enable_libproxy:BuildRequires: libproxy-devel >= %libproxy_ver}

%description
This package contains modules that extend the networking support in GIO.
In particular, it contains a libproxy-based GProxyResolver implementation
and a gnutls-based GTlsConnection implementation.

%package -n glib-openssl
Summary: Network-related giomodule for glib using openssl
Group: System/Libraries

%description -n glib-openssl
This package contains the implementations of certain GLib openssl
features that cannot be implemented directly in GLib itself because of
their dependencies

%package tests
Summary: Tests for the %name package
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name package.


%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%meson \
	%{?_enable_tls:-Dgnutls=enabled} \
	%{?_enable_ssl:-Dopenssl=enabled} \
	%{?_enable_libproxy:-Dlibproxy=enabled} \
	%{?_enable_gnome_proxy:-Dgnome_proxy=enabled} \
	%{?_enable_installed_tests:-Dinstalled_tests=true}
%meson_build

%install
%meson_install
%find_lang %name

%check
%meson_test

%files -f %name.lang
%{?_enable_tls:%_libdir/gio/modules/libgiognutls.so}
%{?_enable_gnome_proxy:%_libdir/gio/modules/libgiognomeproxy.so}
%if_enabled libproxy
%_libdir/gio/modules/libgiolibproxy.so
%_libexecdir/glib-pacrunner
%_datadir/dbus-1/services/org.gtk.GLib.PACRunner.service
%_userunitdir/glib-pacrunner.service
%endif
%doc NEWS README

%if_enabled ssl
%files -n glib-openssl
%_libdir/gio/modules/libgioopenssl.so
%doc NEWS README
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%changelog
