%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _name control-center
%define ver_major 3.32
%define api_ver 2.0

%def_disable debug
%def_with cheese
%def_with bluetooth
%def_enable doc

Name: gnome-control-center
Version: %ver_major.2
Release: alt1

Summary: GNOME Control Center
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

# par example: git-archive-all.sh --format tar --prefix gnome-control-center-3.2.2/ gnome-control-center-3.2.2.tar
%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%endif

%define gtk_ver 3.22.0
%define glib_ver 2.44.0
%define desktop_ver 3.30.1
%define fontconfig_ver 1.0.0
%define gsds_ver 3.31.90
%define nm_ver 1.2
%define goa_ver 3.21.5
%define acc_ver 0.6.33
%define sett_daemon_ver 3.31.90
%define cheese_ver 3.9.5
%define bt_ver 3.18.2
%define systemd_ver 40
%define wacom_ver 0.7
%define ibus_ver 1.5.2
%define colord_ver 1.0
%define pwq_ver 1.2.2
%define upower_ver 0.99.0
%define grilo_ver 0.3.0
%define polkit_ver 0.103

Requires: %name-data = %version-%release

# For /usr/share/gnome
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= %sett_daemon_ver
# for graphical passwd changing apps
Requires: accountsservice
#Requires: userpasswd
Requires: gnome-online-accounts >= %goa_ver
%{?_with_cheese:Requires: cheese >= %cheese_ver}

BuildRequires(pre): meson rpm-build-gnome
BuildPreReq: desktop-file-utils gtk-doc xsltproc libappstream-glib-devel
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: gsettings-desktop-schemas-devel >= %gsds_ver
BuildPreReq: gnome-settings-daemon-devel >= %sett_daemon_ver
BuildPreReq: libcolord-devel >= %colord_ver
BuildPreReq: libcolord-gtk-devel
BuildPreReq: libsoup-devel
BuildPreReq: libibus-devel >= %ibus_ver libxkbfile-devel
BuildRequires: libupower-devel >= %upower_ver libpolkit1-devel >= %polkit_ver
BuildRequires: libgio-devel librsvg-devel libxml2-devel libcanberra-gtk3-devel
BuildRequires: libX11-devel libXext-devel libSM-devel libXScrnSaver-devel libXt-devel
BuildRequires: libXft-devel libXi-devel libXrandr-devel libXrender-devel libXcursor-devel libXcomposite-devel
BuildRequires: libgtop-devel libcups-devel libpulseaudio-devel iso-codes-devel
BuildRequires: libpwquality-devel >= %pwq_ver  libkrb5-devel libsmbclient-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
# for test-endianess
BuildRequires: glibc-i18ndata
BuildRequires: libnm-devel >= %nm_ver libmm-glib-devel libnma-devel
BuildRequires: libgnome-online-accounts-devel >= %goa_ver
BuildRequires: libaccountsservice-devel >= %acc_ver
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: libclutter-gtk3-devel
BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libsecret-devel
BuildRequires: libudisks2-devel
%{?_with_cheese:BuildPreReq: libcheese-devel >= %cheese_ver}
%{?_with_bluetooth:BuildRequires: libgnome-bluetooth-devel >= %bt_ver}
BuildRequires: libgudev-devel libgsound-devel
BuildRequires: libhandy-devel

%description
GNOME (the GNU Network Object Model Environment) is an attractive and
easy-to-use GUI desktop environment. The control-center package
provides the GNOME Control Center utilities that allow you to setup
and configure your system's GNOME environment (things like the desktop
background and theme, the screensaver, the window manager, system
sounds, and mouse behavior).

If you install GNOME, you need to install control-center.

%package data
Summary: Arch independent files for GNOME Control Center
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for GNOME Control Center to work.

%package devel
Summary: GNOME Control Center development files
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name = %version-%release

%description devel
If you're interested in developing panels for the GNOME control center,
you'll want to install this package.

%name-devel helps you create the panels for the control center.

%prep
%setup

%build
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
%endif
%meson \
    %{?_with_cheese:-Dcheese=true} \
    %{?_enable_doc:-Ddocumentation=true}

%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name-%api_ver %name-%api_ver-timezones %_name

%files
%_bindir/%name
%_libexecdir/cc-remote-login-helper
%_libexecdir/gnome-control-center-search-provider

%files data -f %name.lang
%dir %_datadir/%name
%_datadir/%name/keybindings
%_datadir/%name/pixmaps
%_desktopdir/*.desktop
%_datadir/pixmaps/faces/
%_iconsdir/hicolor/*/*/*
%_datadir/sounds/gnome/default/alerts/*.ogg
%_datadir/glib-2.0/schemas/org.gnome.ControlCenter.gschema.xml
%_datadir/polkit-1/actions/org.gnome.controlcenter.datetime.policy
%_datadir/polkit-1/actions/org.gnome.controlcenter.user-accounts.policy
%_datadir/polkit-1/rules.d/gnome-control-center.rules
%_datadir/polkit-1/actions/org.gnome.controlcenter.remote-login-helper.policy
%_datadir/dbus-1/services/org.gnome.ControlCenter.SearchProvider.service
%_datadir/dbus-1/services/org.gnome.ControlCenter.service
%_datadir/gnome-shell/search-providers/gnome-control-center-search-provider.ini
%{?_enable_doc:%_man1dir/%name.1.*}
%_datadir/bash-completion/completions/gnome-control-center
%_datadir/metainfo/%name.appdata.xml
%doc NEWS README*

%files devel
%_datadir/pkgconfig/gnome-keybindings.pc
%_datadir/gettext/its/gnome-keybindings.its
%_datadir/gettext/its/gnome-keybindings.loc
%_datadir/gettext/its/sounds.its
%_datadir/gettext/its/sounds.loc


%changelog
