%define _unpackaged_files_terminate_build 1

%define _name tali
%define xdg_name org.gnome.Tali
%define ver_major 3.32
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt1

Summary: Gnome version of Yahtzee Dice Game
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Tali

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

Provides:  %_name = %version-%release
Obsoletes: gnome-games-gtali
Provides:  gnome-games-gtali = %version-%release

%define glib_ver 2.32.0
%define gtk_ver 3.4.0

BuildRequires(pre): meson
BuildRequires: vala-tools yelp-tools desktop-file-utils
BuildRequires: gsettings-desktop-schemas-devel libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel

%description
Gnome Tali is a sort of poker with dice and less money. You roll five
dice three times and try to create the best hand. Your two rerolls may
include any or all of your dice.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%_name.lang %_name gtali

%files -f %_name.lang
%attr(2711,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_man6dir/%_name.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
