%def_disable snapshot

%define ver_major 3.32
%define xdg_name org.gnome.Music
%define gst_api_ver 1.0

Name: gnome-music
Version: %ver_major.2
Release: alt1

Summary: Music playing application for GNOME3
Group: Sound
License: GPLv2+
Url: http://wiki.gnome.org/Apps/Music

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

# use python3
AutoReqProv: nopython
%define __python %nil
%add_typelib_req_skiplist typelib(Gd)

%define tracker_ver 2.0
%define gtk_ver 3.20.0
%define grilo_ver 0.3.6
%define python_ver 3.3
%define mediaart_ver 1.9
%define pygobject_ver 3.29.1
%define pycairo_ver 1.14.0

Requires: tracker >= %tracker_ver
Requires: grilo-plugins

# gir-python.req doesn't recognize multiline expressions (see gnomemusic/albumartcache.py)
Requires: typelib(MediaArt) = 2.0 typelib(GstTag)

# gnomemusic/widgets/songwidget.py:from gi.repository.Dazzle import BoldingLabel  # noqa: F401
Requires: typelib(Dazzle)

# 3.30
#python3(gi.repository.Dazzle) < 0
#python3(gi.repository.Gd) < 0

%add_python3_req_skip gi.repository.Dazzle gi.repository.Gd

Requires: gst-plugins-base%gst_api_ver grilo-tools >= %grilo_ver tracker >= %tracker_ver

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: %_bindir/git
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgtk+3-devel >= %gtk_ver libdazzle-devel libsoup-devel
BuildRequires: libgrilo-devel >= %grilo_ver grilo-plugins-devel
BuildRequires: libmediaart2.0-devel >= %mediaart_ver
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: python3-devel >= %python_ver
BuildRequires: pkgconfig(tracker-sparql-2.0)
BuildRequires: python3-module-pygobject3-devel >= %pygobject_ver python3-module-pycairo-devel >= %pycairo_ver
BuildRequires: libgnome-online-accounts-devel

%description
Music playing application for GNOME3.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name %xdg_name

%files -f %name.lang
%_bindir/%name
%_datadir/%xdg_name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/org.gnome.Music.gschema.xml
%_iconsdir/hicolor/*/*/*.svg
%_libdir/%xdg_name/
%python3_sitelibdir_noarch/gnomemusic/
%_datadir/metainfo/%xdg_name.appdata.xml
#%_man1dir/%name.1.*
%doc README* NEWS*

%changelog
