%define ver_major 3.30
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%def_enable facebook
%def_enable flickr
%def_enable google
%def_enable media_server
%def_enable owncloud
%def_enable windows_live

Name: gnome-online-miners
Version: %ver_major.0
Release: alt1

Summary: A set of miners for online content
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://git.gnome.org/browse/gnome-online-miners

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.36
%define goa_ver 3.14.0
%define grilo_ver 0.3
%define gdata_ver 0.15.2
%define zapojit_ver 0.0.2
%define tracker_ver 0.17.1
%define gfbgraph_ver 0.2.2

%{?_enable_flickr:Requires: grilo-plugins >= %grilo_ver}

BuildRequires: gnome-common
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgnome-online-accounts-devel >= %goa_ver
BuildRequires: pkgconfig(tracker-miner-2.0) pkgconfig(tracker-sparql-2.0)
%{?_enable_google:BuildPreReq: libgdata-devel >= %gdata_ver}
%{?_enable_flickr:BuildPreReq: libgrilo-devel >= %grilo_ver}
%{?_enable_facebook:BuildPreReq: libgfbgraph-devel >= %gfbgraph_ver}
%{?_enable_windows_live:BuildPreReq: libzapojit-devel >= %zapojit_ver}

%description
GNOME Online Miners provides a set of crawlers that go through your
online content and index them locally in Tracker. It has miners for
Flickr, Google, SkyDrive and ownCloud.

%prep
%setup

%build
%autoreconf
%configure --disable-static \
	%{subst_enable facebook} \
	%{subst_enable flickr} \
	%{subst_enable google} \
	%{?_enable_media_server:--enable-media-server} \
	%{subst_enable owncloud} \
	%{?_enable_windows_live:--enable-windows-live}
%make_build

%install
%makeinstall_std

%files
%_libexecdir/gom-facebook-miner
%_libexecdir/gom-flickr-miner
%_libexecdir/gom-gdata-miner
%_libexecdir/gom-media-server-miner
%_libexecdir/gom-owncloud-miner
%_libexecdir/gom-zpj-miner
%dir %_libdir/%name
%_libdir/%name/libgom-%api_ver.so
%_datadir/dbus-1/services/org.gnome.OnlineMiners.Facebook.service
%_datadir/dbus-1/services/org.gnome.OnlineMiners.Flickr.service
%_datadir/dbus-1/services/org.gnome.OnlineMiners.GData.service
%_datadir/dbus-1/services/org.gnome.OnlineMiners.MediaServer.service
%_datadir/dbus-1/services/org.gnome.OnlineMiners.Owncloud.service
%_datadir/dbus-1/services/org.gnome.OnlineMiners.Zpj.service
%doc AUTHORS NEWS README

%exclude %_libdir/%name/libgom-%api_ver.la
%exclude %_datadir/doc/%name

%changelog
