%set_verify_elf_method unresolved=relaxed

%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define ver_major 3.32
%define api_ver 3.0
%define xdg_name org.gnome.SettingsDaemon

%def_enable smartcard
%def_enable systemd
%def_enable wayland
# tests require, as minimum, running colord
%def_disable check
%def_disable tests
# see NEWS 3.30.1.2
%def_disable suspend_then_hibernate

Name: gnome-settings-daemon
Version: %ver_major.1
Release: alt1

Summary: A program that manages general GNOME settings
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.54.0
%define gtk_ver 3.16
%define gnome_desktop_ver 3.29.90.1
%define notify_ver 0.7.3
%define pulse_ver 0.9.15
%define gsds_ver 3.23.3
%define colord_ver 0.1.9
%define dconf_ver 0.8
%define upower_ver 0.9.1
%define systemd_ver 40
%define wacom_ver 0.7
%define geocode_ver 3.10.0
%define geoclue_ver 2.3.1
%define gweather_ver 3.9.5
%define nm_ver 1.0
%define lcms_ver 2.2

Requires: dconf >= %dconf_ver
Requires: colord >= %colord_ver
Requires: system-config-printer
Requires: system-config-printer-udev
Requires: rfkill
Requires: geoclue2 >= %geoclue_ver
Requires: xkeyboard-config
Requires: iio-sensor-proxy

BuildRequires(pre): meson
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnome-desktop3-devel >= %gnome_desktop_ver
BuildRequires: libnotify-devel >= %notify_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libpulseaudio-devel >= %pulse_ver libalsa-devel libcanberra-gtk3-devel
BuildRequires: libdbus-devel libpolkit1-devel
BuildRequires: xkeyboard-config-devel
%{?_enable_smartcard:BuildRequires: libnss-devel}
%{?_enable_systemd:BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel}
%{?_enable_wayland:BuildRequires: libwayland-client-devel}
BuildRequires: libxkbfile-devel
BuildRequires: rpm-build-gnome docbook-style-xsl xsltproc
BuildRequires: gcc-c++ libcups-devel libgudev-devel libX11-devel libXi-devel libXext-devel libXfixes-devel
BuildRequires: libXrandr-devel xorg-proto-devel libICE-devel libSM-devel
BuildRequires: libupower-devel >= %upower_ver
BuildRequires: libcolord-devel >= %colord_ver liblcms2-devel >= %lcms_ver librsvg-devel
BuildRequires: libwacom-devel >= %wacom_ver xorg-drv-wacom-devel
BuildRequires: libgweather-devel >= %gweather_ver libgeocode-glib-devel >= %geocode_ver libgeoclue2-devel >= %geoclue_ver
BuildRequires: libnm-devel >= %nm_ver

# for check
%{?_enable_check:BuildRequires: /proc dbus gnome-color-manager}

%description
GNOME Settings Daemon is a program that organizes access to general GNOME
settings. Other GNOME programs may interact with gnome-settings-daemon to
obtain or change some settings. One of the most prominent examples of a g-s-d
client is GNOME Control Center, another one is Evolution.

%package devel
Summary: GNOME Settings Daemon development files
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tests
Summary: GSD test programms
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description tests
The %name-tests package provides programms for testing GSD plugins.

%prep
%setup

%build
%meson \
	%{?_disable_smartcard:-Dsmartcard=false} \
	%{?_enable_wayland:-Dwayland=true} \
	-Dudev_dir='/lib/udev' \
	%{?_enable_suspend_then_hibernate:-Dexperimental_suspend_then_hibernate=true}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%meson_test

%files -f %name.lang
%dir %_libdir/%name-%api_ver
%_libdir/%name-%api_ver/libgsd.so
#%_libexecdir/gsd-a11y-keyboard
%_libexecdir/gsd-a11y-settings
%_libexecdir/gsd-backlight-helper
%_libexecdir/gsd-clipboard
%_libexecdir/gsd-color
%_libexecdir/gsd-datetime
%_libexecdir/gsd-dummy
%_libexecdir/gsd-housekeeping
%_libexecdir/gsd-keyboard
%_libexecdir/gsd-locate-pointer
%_libexecdir/gsd-media-keys
%_libexecdir/gsd-mouse
%_libexecdir/gsd-power
%_libexecdir/gsd-print-notifications
%_libexecdir/gsd-printer
%_libexecdir/gsd-rfkill
%_libexecdir/gsd-screensaver-proxy
%_libexecdir/gsd-sharing
%_libexecdir/gsd-smartcard
%_libexecdir/gsd-sound
%_libexecdir/gsd-wacom
%_libexecdir/gsd-wacom-led-helper
%_libexecdir/gsd-wacom-oled-helper
%_libexecdir/gsd-xsettings
%_datadir/%name/
%_sysconfdir/xdg/autostart/*.desktop
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/polkit-1/actions/org.gnome.settings-daemon.plugins.power.policy
%_datadir/polkit-1/actions/org.gnome.settings-daemon.plugins.wacom.policy
%_udevrulesdir/61-gnome-settings-daemon-rfkill.rules
%doc AUTHORS NEWS

%files devel
%_includedir/%name-%api_ver/
%_pkgconfigdir/%name.pc

%if_enabled tests
%files tests
%_libexecdir/gsd-test-a11y-keyboard
%_libexecdir/gsd-test-a11y-settings
%_libexecdir/gsd-test-datetime
%_libexecdir/gsd-test-housekeeping
%_libexecdir/gsd-test-input-helper
%_libexecdir/gsd-test-keyboard
%_libexecdir/gsd-test-media-keys
%_libexecdir/gsd-test-mouse
%_libexecdir/gsd-test-orientation
%_libexecdir/gsd-test-print-notifications
%_libexecdir/gsd-test-rfkill
%_libexecdir/gsd-test-screensaver-proxy
%_libexecdir/gsd-test-smartcard
%_libexecdir/gsd-test-sound
%_libexecdir/gsd-test-wacom
%_libexecdir/gsd-test-wacom-osd
%_libexecdir/gsd-test-xrandr
%_libexecdir/gsd-test-xsettings
%endif

%changelog
