%define _unpackaged_files_terminate_build 1

%define ver_major 3.32
%def_enable systemd
%def_disable wnck

%define _libexecdir %_prefix/libexec

Name: gnome-system-monitor
Version: %ver_major.1
Release: alt1

Summary: Simple process monitor
License: GPLv2+
Group: Monitoring
Url: https://wiki.gnome.org/Apps/SystemMonitor

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.56.0
%define gtk_ver 3.22
%define glibmm_ver 2.28.0
%define libgtkmm3_ver 3.3.18
%define libwnck_ver 3.0.0
%define libgtop_ver 2.38.0
%define libxml_ver 2.0
%define rsvg_ver 2.35

BuildRequires(pre): meson rpm-build-gnome
BuildRequires: gcc-c++ libappstream-glib-devel
BuildRequires: yelp-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libglibmm-devel >= %glibmm_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgtkmm3-devel >= %libgtkmm3_ver
BuildRequires: libgtop-devel >= %libgtop_ver
BuildRequires: libxml2-devel >= %libxml_ver
BuildRequires: librsvg-devel >= %rsvg_ver
BuildRequires: libpolkit-devel
%{?_enable_wnck:BuildRequires: libwnck3-devel >= %libwnck_ver}
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}

%description
Gnome-system-monitor is a simple process and system monitor.

%prep
%setup

%build
%meson \
    %{?_enable_systemd:-Dsystemd=true} \
    %{?_enable_wnck:-Dwnck=true}
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/gsm-kill
%_libexecdir/%name/gsm-renice
%_desktopdir/*
%_datadir/%name/
%_datadir/polkit-1/actions/org.gnome.%name.policy
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.%name.enums.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%name.appdata.xml


%changelog
