%set_verify_elf_method unresolved=strict

#based on Fedora's spec

Name: gnustep-back    
Version: 0.24.0
Release: alt6.svn20140127.1
Summary: The GNUstep back-end library
License: LGPLv3+ and GPLv3+
Group: Graphical desktop/GNUstep
URL: http://www.gnustep.org
# http://svn.gna.org/svn/gnustep/libs/back/trunk/
Source: %name-%version.tar
Source1: Courier.FontInfo.plist
Source2: Times.FontInfo.plist

BuildPreReq: libfreetype-devel libX11-devel libXt-devel libXext-devel
BuildPreReq: libXmu-devel libICE-devel libXft-devel libGL-devel
BuildPreReq: libart_lgpl-devel clang-devel libglitz-devel libcairo-devel
BuildPreReq: gnustep-make-devel gnustep-gui-devel gnustep-base-devel
BuildPreReq: libgnustep-objc2-devel libXcursor-devel libXfixes-devel
BuildPreReq: fonts-type1-urw gnustep-gui-doc
BuildRequires: texinfo /proc
BuildPreReq: libgmp-devel libgnutls-devel libgcrypt-devel
BuildPreReq: libxslt-devel libffi-devel libicu-devel

Requires: fonts-type1-urw gnustep-base gnustep-gui

%description 
This is a back-end for the GNUstep GUI library which allows you to use
the GNUstep GUI library on an X Windows System (other back-ends will
be added later to allow you to use the GNUstep GUI Library in other
windowing environments). This package includes development headers too.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: gnustep-gui-doc

%description doc
This is develompent documentation for %name.

%prep
%setup

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-glitz \
	--enable-server=x11 \
%ifarch x86_64
	--enable-graphics=cairo \
%else
	--enable-graphics=xlib \
%endif
	--with-tiff-library \
	--with-x \
	--with-installation-domain=SYSTEM

%ifarch x86_64
sed -i 's|i586|x86_64|g' $(find ./ -type f)
%endif
%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes

%make_build -C Documentation \
	messages=yes

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

%makeinstall_std -C Documentation \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

rm -rf \
	%buildroot%_libdir/GNUstep/Documentation/Developer/Back/ReleaseNotes

pushd %buildroot%_libdir/GNUstep/Fonts/Helvetica.nfont
for i in $(ls *.?f?); do
	rm -f $i
	ln -s %_datadir/fonts/type1/urw/$i ./
done
popd

install -d %buildroot%_libdir/GNUstep/Fonts/Courier.nfont
pushd %buildroot%_libdir/GNUstep/Fonts/Courier.nfont
install -p -m644 %SOURCE1 ./FontInfo.plist
for i in n022003l n022023l n022004l n022024l; do
	ln -s %_datadir/fonts/type1/urw/$i.afm ./
	ln -s %_datadir/fonts/type1/urw/$i.pfb ./
	ln -s %_datadir/fonts/type1/urw/$i.pfm ./
done
popd

install -d %buildroot%_libdir/GNUstep/Fonts/Times.nfont
pushd %buildroot%_libdir/GNUstep/Fonts/Times.nfont
install -p -m644 %SOURCE2 ./FontInfo.plist
for i in n021003l n021023l n021004l n021024l; do

	ln -s %_datadir/fonts/type1/urw/$i.afm ./
	ln -s %_datadir/fonts/type1/urw/$i.pfb ./
	ln -s %_datadir/fonts/type1/urw/$i.pfm ./
done
popd

install -d %buildroot%_sysconfdir/profile.d
echo "export GNUSTEP_STRING_ENCODING=UTF-8" \
	> %buildroot%_sysconfdir/profile.d/%name.sh
chmod +x %buildroot%_sysconfdir/profile.d/%name.sh

gzip ChangeLog

%files
%doc ANNOUNCE ChangeLog* COPYING* NEWS README
%_sysconfdir/profile.d/*
%_bindir/*
%_libdir/GNUstep
%_man1dir/*

%files doc
%_docdir/GNUstep

%changelog
