%define _unpackaged_files_terminate_build 1
Release: alt1.git36a1881
Version: 1.5.0

Name: goldendict

Summary: Feature-rich dictionary lookup program
License: GPLv3
Group: Education
URL: http://www.goldendict.org

Source0: %name-%version.tar
Patch0: goldendict-ru-desktop.patch
BuildRequires(pre): libXtst-devel bzlib-devel

BuildRequires: gcc-c++ libX11-devel libvorbis-devel libzip-devel libhunspell-devel
BuildRequires: qt5-phonon-devel qt5-base-devel qt5-script-devel qt5-tools qt5-x11extras-devel qt5-multimedia-devel libao-devel libavformat-devel
BuildRequires: libavutil-devel qt5-tools-devel qt5-svg-devel qt5-webkit-devel eb-devel liblzo2-devel libtiff-devel

%description
GoldenDict is feature-rich dictionary lookup program. Features:
* Use of WebKit for an accurate articles' representation, complete with
  all formatting, colors, images and links.
* Support of multiple dictionary file formats, namely:
  - Babylon .BGL files, complete with images and resources
  - StarDict .ifo/.dict./.idx/.syn dictionaries
  - Dictd .index/.dict(.dz) dictionary files
  - ABBYY Lingvo .dsl source files, together with abbreviations. The
    files can be optionally compressed with dictzip. Dictionary
    resources can be packed together into a .zip file.
  - ABBYY Lingvo .lsa/.dat audio archives. Those can be indexed
    separately, or be referred to from .dsl files.
* Support for Wikipedia, Wiktionary, or any other MediaWiki-based sites
  to perform lookups in.
* Ability to use arbitrary websites as dictionaries via templated Url
  patterns.
* Support for looking up and listening to pronunciations from forvo.com
* Hunspell-based morphology system, used for word stemming and spelling
  suggestions.
* Ability to index arbitrary directories with audio files for
  pronunciation lookups.
* Full Unicode case, diacritics, punctuation and whitespace folding.
  This means the ability to type in words without any accents, correct
  case, punctuation or spaces.
* Scan popup functionality. A small window pops up with the translation
  of a word chosen from another application.
* Support for global hotkeys. You can spawn the program window at any
  point, or directly translate a word from the clipboard.
* Tabbed browsing in a modern Qt 4 interface.
%prep
%setup -q
%patch0 -p1

%build
PREFIX=%_prefix /usr/bin/qmake-qt5 DISABLE_INTERNAL_PLAYER=1 CONFIG+=no_epwing_support
%make

%install
PREFIX=%_prefix /usr/bin/qmake-qt5
%make_install INSTALL_ROOT=%buildroot install

# our find-lang.sh doesn't recognize .qm translation files
#find_lang --with-qt goldendict
find %buildroot%_datadir -name '*.qm' -print \
	| sed -e 's,%buildroot,,' -e 's,^\(.*\)/\([^/]*\)\.qm$,%%lang(\2) \1/\2.qm,' \
	> goldendict.lang

rm -rf %buildroot%_datadir/app-install

%files -f goldendict.lang
%_bindir/*
%attr(0644, root, root) %_datadir/applications/*.desktop
%_pixmapsdir/*
%dir %_datadir/%name
%dir %_datadir/%name/locale
%_datadir/%name/help

%changelog
