%global import_path github.com/grafana/grafana

%global _unpackaged_files_terminate_build 1
%define _runtimedir /run

Name:		grafana
Version:	7.5.13
Release:	alt1
Summary:	Metrics dashboard and graph editor

Group:		Development/Other
License:	Apache-2.0
URL:		https://grafana.com

Source: %name-%version.tar
Patch: %name-%version.patch

Source100: %name-server.sysconfig
#Source101: %name.logrotate
Source102: %name-server.init
Source103: %name-server.service
Source104: %name.tmpfiles


#ExclusiveArch: %go_arches
# on ppc64le error:
# error Command failed with signal "SIGXCPU"
ExclusiveArch: %ix86 x86_64 %arm aarch64 mipsel riscv64
BuildRequires(pre): rpm-build-golang rpm-macros-nodejs
BuildRequires: npm yarn
BuildRequires: node node-devel node-gyp node-iltorb node-sass libsass
BuildRequires: fontconfig libfreetype
BuildRequires: /proc

%description
Grafana is an open source, feature rich metrics dashboard and graph editor
for Graphite, Elasticsearch, OpenTSDB, Prometheus and InfluxDB.

%prep
# Build the Front-end Assets
# $ npm install yarn
# $ ./node_modules/.bin/yarn install --pure-lockfile
# $ npm run build
# $ rm -rf node_modules/iltorb
# $ rm -rf node_modules/node-sass
# $ rm -rf node_modules/node-gyp
# $ git add -f node_modules
# $ git add -f packages/*/node_modules
# $ git add -f plugins-bundled/internal/input-datasource/node_modules
# $ git commit -n --no-post-rewrite -m "add node js modules"
#
# Go vendors modules
# $ go mod vendor -v
# $ git add -f vendor
# $ git commit -n --no-post-rewrite -m "update go modules by go mod vendor"

%setup -q
%patch -p1

# add symlink to node headers
node_ver=$(node -v | sed -e "s/v//")
mkdir -p node_modules/.node-gyp/$node_ver/include
ln -s %_includedir/node node_modules/.node-gyp/$node_ver/include/node
echo "9" > node_modules/.node-gyp/$node_ver/installVersion

ln -sf %nodejs_sitelib/node-gyp node_modules/node-gyp
ln -sf %nodejs_sitelib/node-sass node_modules/node-sass
ln -sf %nodejs_sitelib/iltorb node_modules/iltorb

%build

export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export npm_config_devdir="$PWD/node_modules/.node-gyp"
export VERSION=%version
export COMMIT=%release
export BRANCH=altlinux

#%golang_prepare
#cd .gopath/src/%import_path
mkdir -p $BUILDDIR/src/github.com/grafana
ln -s %_builddir/%name-%version \
    $BUILDDIR/src/%import_path

pushd $BUILDDIR/src/%import_path


%ifarch %arm %ix86 %mips32 %mipsn32
export NODE_OPTIONS=--max_old_space_size=2048
%endif
#npm rebuild
#npm run build
#go run build.go build-frontend
yarn run build

#GO111MODULE=off CGO_ENABLED=1 go run build.go build
#%%golang_build pkg/cmd/*
CGO_ENABLED=1 go install -ldflags " -s -w  \
    -X main.version=$VERSION \
    -X main.commit=$COMMIT \
    -X main.buildBranch=$BRANCH \
    " -a ./pkg/cmd/grafana-server

CGO_ENABLED=1 go install -ldflags " -s -w  \
    -X main.version=$VERSION \
    -X main.commit=$COMMIT \
    -X main.buildBranch=$BRANCH \
    " -a ./pkg/cmd/grafana-cli

popd

%install
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path:$PWD"
export GOFLAGS="-mod=vendor"

pushd $BUILDDIR/src/%import_path
# Install Front-end Assets
install -d -m 755 %buildroot%_datadir/%name
cp -pr conf %buildroot%_datadir/%name/
cp -pr public %buildroot%_datadir/%name/
%golang_install
popd

rm -rf -- %buildroot/usr/src
rm -f -- %buildroot%_bindir/govendor
rm -f -- %buildroot%_bindir/release_publisher
rm -f -- %buildroot%_bindir/slow_proxy
#TODO: package alert_webhook_listener
rm -f -- %buildroot%_bindir/alert_webhook_listener

# Install config files
install -p -D -m 640 conf/sample.ini %buildroot%_sysconfdir/%name/%name.ini
install -p -D -m 640 conf/ldap.toml %buildroot%_sysconfdir/%name/ldap.toml
mkdir -p %buildroot%_sysconfdir/%name/provisioning/{dashboards,datasources,notifiers}
install -p -D -m 640 conf/provisioning/dashboards/sample.yaml %buildroot%_sysconfdir/%name/provisioning/dashboards/sample.yaml
install -p -D -m 640 conf/provisioning/datasources/sample.yaml %buildroot%_sysconfdir/%name/provisioning/datasources/sample.yaml
install -p -D -m 640 conf/provisioning/notifiers/sample.yaml %buildroot%_sysconfdir/%name/provisioning/notifiers/sample.yaml

# Setup directories
install -d -m 755 %buildroot%_logdir/%name
install -d -m 750 %buildroot%_sharedstatedir/%name
install -d -m 755 %buildroot%_sharedstatedir/%name/plugins
# Install pid directory
install -d -m 775 %buildroot%_runtimedir/%name
# Install sysconfig
install -p -D -m 644 %SOURCE100 %buildroot%_sysconfdir/sysconfig/%name-server
# Install logrotate
#install -p -D -m 644 %%SOURCE101 %buildroot%_logrotatedir/%name
# Install sysv init scripts
install -p -D -m 755 %SOURCE102 %buildroot%_initdir/%name-server
# Install systemd unit services
install -p -D -m 644 %SOURCE103 %buildroot%_unitdir/%name-server.service
install -p -D -m 644 %SOURCE104 %buildroot%_tmpfilesdir/%name.conf

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -g %name -G %name  -c 'Grafana Daemon' \
        -s /sbin/nologin  -d %_sharedstatedir/%name %name 2>/dev/null ||:

%post
%post_service %name-server
# create grafana.db with secure permissions on new installations
# otherwise grafana-server is creating grafana.db on first start
# with world-readable permissions, which may leak encrypted datasource
# passwords to all users (if the secret_key in grafana.ini was not changed)
if [ "$1" = 1 ] && [ ! -f %_sharedstatedir/%name/grafana.db ]; then
    touch %_sharedstatedir/%name/grafana.db
fi
 
# apply secure permissions to grafana.db if it exists
# (may not exist on upgrades, because users can choose between sqlite/mysql/postgres)
if [ -f %_sharedstatedir/%name/grafana.db ]; then
    chown %name:%name %_sharedstatedir/%name/grafana.db
    chmod 640 %_sharedstatedir/%name/grafana.db
fi

%preun
%preun_service %name-server

%files
%doc CHANGELOG.md LICENSE README.md
%_bindir/%name-cli
%_bindir/%name-server
%config(noreplace) %_sysconfdir/sysconfig/%name-server
%_initdir/%name-server
%_unitdir/%name-server.service
%_tmpfilesdir/%name.conf
%dir %attr(0750, root, %name) %_sysconfdir/%name
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/dashboards
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/datasources
%dir %attr(0750, root, %name) %_sysconfdir/%name/provisioning/notifiers
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/%name.ini
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/ldap.toml
%config(noreplace) %attr(0640, root, %name) %_sysconfdir/%name/provisioning/*/*.yaml
#%config(noreplace) %_logrotatedir/%name
%dir %attr(0775, root, %name) %_logdir/%name
%dir %attr(0750, %name, %name) %_sharedstatedir/%name
%dir %attr(0755, %name, %name) %dir %_sharedstatedir/%name/plugins
%_datadir/%name

%changelog
