%def_without bootstrap

%if_without bootstrap
# help is welcome to re-enable, fix packaging and test
%def_enable  guile
%def_enable lua
%def_disable ocaml
%def_disable php
%def_disable python2
%def_enable python3
%def_disable ruby
%def_enable tcl
%endif

%define gvdatadir %_datadir/%name
%define gvlibdir %_libdir/%name
%define gvtcldir %_libexecdir/%name/tcl

Name: graphviz
Version: 2.41.2
Release: alt4

Summary: Graphs visualization tools
License: EPL-1.0 and GPL-2.0+ with Bison-exception and CPL-1.0
Group: Publishing
Packager: Fr. Br. George <george@altlinux.org>
Url: https://www.graphviz.org
Vcs: https://gitlab.com/graphviz/graphviz
Source0: %name-%version.tar
Source2: graphviz-dot-x11-preview.desktop

Patch0:  graphviz-2.24.0-alt-perl-5.12.patch
Patch1:  graphviz-2.28.0-alt-string_h_trhow.patch
Patch2:  graphviz-2.38.0-gs-9.18-fix.patch
Patch3:  graphviz-2.41.2-alt-add-riscv64.patch

# From Fedora:
Patch40:                 graphviz-2.40.1-visio.patch
Patch41:                 graphviz-2.40.1-python3.patch
# https://gitlab.com/graphviz/graphviz/issues/1367
Patch42:                 graphviz-2.40.1-CVE-2018-10196.patch
# rhbz#1505230
Patch43:                 graphviz-2.40.1-dotty-menu-fix.patch
Patch44:                 graphviz-2.40.1-coverity-scan-fixes.patch

Requires: lib%name = %version-%release
Provides: libdotneato = %version
Obsoletes: libdotneato < %version

# Automatically added by buildreq on Wed Apr 23 2014 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel gnu-config guile18 libGL-devel libGLU-devel libICE-devel libSM-devel libX11-devel libXext-devel libXmu-devel libXrender-devel libXt-devel libatk-devel libcairo-devel libcloog-isl4 libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgmp-devel libgtk+2-devel libltdl7-devel libpango-devel libpangox-compat libpangox-compat-devel libpng-devel libqt4-core libqt4-devel libqt4-gui libstdc++-devel libwayland-client libwayland-server perl-devel pkg-config python-base rpm-build-tcl tcl tcl-devel tk xorg-renderproto-devel xorg-xproto-devel zlib-devel
BuildRequires: flex gcc-c++ groff-base imake libXaw-devel libXpm-devel libann-devel libexpat-devel libgd2-devel swig tk-devel xorg-cf-files libltdl-devel

%{?!_with_bootstrap:BuildRequires: ghostscript-utils libfreeglut-devel libglade-devel libgs-devel libgtkglext-devel libgts-devel liblasi-devel librsvg-devel}
%{?_enable_lua:BuildRequires: liblua5-devel}
%{?_enable_guile:BuildRequires: guile-devel}
%if_enabled python3
BuildRequires(pre): rpm-build-python3 python3-devel
%add_python3_path %gvlibdir/python3/
%endif

%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist %gvdatadir/demo/*.pl
%add_findreq_skiplist %gvdatadir/demo/*.tcl
%add_findreq_skiplist %_bindir/vimdot

%description
Graphviz is a set of graph drawing tools originally developed
at AT&T Research.

Graph drawing addresses the problem of visualizing structural
information by constructing geometric representations of abstract
graphs and networks.  Automatic generation of graph drawings has
important applications in key technologies such as database
design, software engineering, VLSI and network design and visual
interfaces in other domains.

# {{{ subpackages
%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries

%description -n lib%name
This package includes shared libraries for %name

%package -n lib%name-devel
Summary: Header files and C programming manual for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
This package includes header files for %name

%package doc
Summary: Documentation for %name
Group: Publishing
Requires: %name = %version-%release
BuildArch: noarch

%description doc
This package contains most of documentation for %name

%package graphs
Summary: Demo graphs for graphviz
Group: Graphics
Requires: %name = %version-%release
BuildArch: noarch

%description graphs
This package provides some example graphs for %name.

%package guile
Summary: Guile bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description guile
This package makes %name functionality accessible from Guile

%package lua
Summary: Lua bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description lua
This package makes %name functionality accessible from Lua

%package perl
Summary: Perl bindings to %name
Group: Development/Perl
Requires: %name = %version-%release

%description perl
This package makes %name functionality accessible from Perl

%package python3
Summary: Python bindings to %name
Group: Development/Python
Requires: %name = %version-%release

%description python3
This package makes %name functionality accessible from Python

%package ruby
Summary: Ruby bindings to %name
Group: Development/Ruby
Requires: %name = %version-%release

%description ruby
This package makes %name functionality accessible from Ruby

%package tcl
Summary: Tcl bindings to %name
Group: Development/Tcl
Requires: %name = %version-%release
Requires: tcl >= 8.4.0-alt1
Provides: tcl-tkspline = %version tcl-gd = %version
Obsoletes: tcl-tkspline < %version tcl-gd < %version

%description tcl
This package makes %name functionality accessible from Tcl

# }}}

%prep
%setup
%patch0 -p1
#patch1
%patch2 -p1
%patch3 -p1

#patch40 -p1 -b .visio
#patch41 -p1 -b .python3
#patch42 -p1 -b .CVE-2018-10196
%patch43 -p1 -b .dotty-menu-fix
%patch44 -p1 -b .coverity-scan-fixes

# XXX Hack out #!/usr/bin/lua
for N in tclpkg/gv/demo/*lua; do
	sed -i 's@#!/usr/bin/lua@#!/usr/bin/env lua@' $N
done

%ifarch %e2k
# 2.41 got hardwired arch list for libsuffix there :-/
sed -i 's,sparc64,& | e2k,' configure.ac
%endif

%build
./autogen.sh NOCONFIG
%add_optflags -DNDEBUG
# altbug #34101
sed -i 's,-Wall -ffast-math,-Wall,' configure*

# skip internal libltdl
rm -rf libltdl/ m4/ltdl.m4
subst 's|^LT|dnl LT|' configure.ac
export LIBLTDL=-lltdl

# http://lists.gnu.org/archive/html/libtool/2008-10/msg00010.html
%autoreconf --no-recursive
%configure \
	--disable-static \
	--with-pangocairo \
	--with-x \
	--with-gdk-pixbuf \
	--without-gnomeui \
	--with-gtk \
	--without-qt \
	--with-ipsepcola \
	--with-sfdp \
	--with-smyrna \
	%{subst_enable guile } \
	%{subst_enable lua } \
	%{subst_enable ocaml } \
	%{subst_enable php } \
	%{subst_enable python2 } \
	%{subst_enable python3 } \
	%{subst_enable ruby } \
	%{subst_enable tcl } \
	--disable-python \
	--disable-java \
	--disable-sharp

%make_build

%install
%makeinstall_std

# avoid %%doc, install by hand
mkdir -p %buildroot%_defaultdocdir
mv %buildroot%gvdatadir/doc %buildroot%_defaultdocdir/%name-%version
cp -a AUTHORS COPYING cpl1.0.txt ChangeLog NEWS %buildroot%_defaultdocdir/%name-%version

%if_enabled tcl
##mkdir -p %buildroot%_tcldatadir/{%name,gd,tkspline}
##cat <<EOF > %buildroot%_tcldatadir/gd/pkgIndex.tcl
##package ifneeded Gdtclft %version "load [file join \$dir .. .. .. lib tcl libgdtclft.so.0] Gdtclft"
##EOF
##cat <<EOF > %buildroot%_tcldatadir/%name/pkgIndex.tcl
##package ifneeded Tcldot %version "load [file join \$dir .. .. .. lib tcl libtcldot.so.0] Tcldot"
##package ifneeded Tclpathplan %version "load [file join \$dir .. .. .. lib tcl libtclplan.so.0] Tclpathplan"
##EOF
##cat <<EOF > %buildroot%_tcldatadir/tkspline/pkgIndex.tcl
##package ifneeded Tkspline %version "
##	package require Tk 8.3
##        load [file join \$dir .. .. .. lib tcl libtkspline.so.0] Tkspline"
##EOF

# argh, #21967
if [ ! -d %buildroot%gvtcldir ]; then
	mkdir -p "$(dirname %buildroot%gvtcldir)"
	mv %buildroot{%_libdir/%name/tcl,%gvtcldir} ||:
fi
%endif

install -m0644 -D %SOURCE2 %buildroot%_desktopdir/graphviz-dot-x11-preview.desktop

# created by %%_bindir/dot -c
touch %buildroot%gvlibdir/config

rm -f %buildroot%gvlibdir/*/lib*.la
rm -f %buildroot%gvtcldir/lib*.la
rm -f %buildroot%gvlibdir/libgvplugin_*.la
rm -fv %buildroot%_datadir/graphviz/demo/modgraph.py

# Dereference manual symlinks
mv %buildroot%_man1dir/* %buildroot%_man3dir/
cp -aL %buildroot%_man3dir/*.1 %buildroot%_man1dir/
rm -f %buildroot%_man3dir/*.1

%post
[ ! -x %_bindir/dot ] || %_bindir/dot -c >&/dev/null

%files
%_bindir/*
%_desktopdir/*.desktop
%dir %gvdatadir/
%gvdatadir/gvpr
%gvdatadir/lefty
%if_without bootstrap
#gvdatadir/gvedit
%gvdatadir/smyrna
%endif
%ghost %gvlibdir/config
%_man1dir/*
%_man7dir/*
%dir %_defaultdocdir/%name-%version/
%_defaultdocdir/%name-%version/AUTHORS
%_defaultdocdir/%name-%version/COPYING
%_defaultdocdir/%name-%version/cpl1.0.txt
%_defaultdocdir/%name-%version/ChangeLog
%_defaultdocdir/%name-%version/NEWS

%files -n lib%name
%_libdir/lib*.so.*
%dir %gvlibdir/
%gvlibdir/lib*.so.*
%gvlibdir/libgvplugin_*.so

%files -n lib%name-devel
%_includedir/%name
%_libdir/lib*.so
%_libdir/pkgconfig/*.pc
%_man3dir/*
%exclude %_man3dir/*tcl*

%files doc
%_defaultdocdir/%name-%version/
%exclude %_defaultdocdir/%name-%version/AUTHORS
%exclude %_defaultdocdir/%name-%version/COPYING
%exclude %_defaultdocdir/%name-%version/cpl1.0.txt
%exclude %_defaultdocdir/%name-%version/ChangeLog
%exclude %_defaultdocdir/%name-%version/NEWS
%{?!_with_bootstrap:%gvdatadir/examples}

%files graphs
%gvdatadir/graphs

%if_enabled guile
%files guile
%dir %gvlibdir/guile/
%gvlibdir/guile/*.so
%endif

%if_enabled lua
%files lua
%dir %gvlibdir/lua/
%gvlibdir/lua/*.so
%_libdir/lua/*/*.so
%gvdatadir/demo/modgraph.lua
%endif

%files perl
%dir %gvlibdir/perl/
%gvlibdir/perl/gv.pm
%gvlibdir/perl/gv.so
%gvlibdir/perl/libgv_perl.so
%perl_vendor_archlib/gv.pm
%perl_vendor_archlib/gv.so
%gvdatadir/demo/modgraph.pl

%if_enabled python3
%files python3
%gvlibdir/python3/
%python3_sitelibdir/*
#gvdatadir/demo/modgraph.py
%endif

%if_enabled ruby
%files ruby
%dir %gvlibdir/ruby/
%gvlibdir/ruby/gv.so
%endif

%if_enabled tcl
%files tcl
%dir %gvtcldir/
%gvtcldir/lib*tcl*.so*
%gvtcldir/*.tcl
%_libdir/tcl*/*
%gvdatadir/demo/*.tcl
%gvdatadir/demo/pathplan*
%gvdatadir/demo/*.README
%gvdatadir/demo/*.html
%_man3dir/*tcl*
%endif

# TODO:
# - enable/fix/test language bindings

%changelog
