Summary: Generator Tools for Coding SOAP/XML Web Services in C and C++
Name: gsoap
Version: 2.8.94
Release: alt2
License: GPLv2+
Group: Development/Tools
URL: http://gsoap2.sourceforge.net
Packager: Evgeny Sinelnikov <sin@altlinux.ru>
Source0: http://downloads.sourceforge.net/gsoap2/gsoap_%version.tar.gz
Patch: %name-%version-alt.patch

#packagereq: optimized out: glibc-devel-static glibc-pthread libcom_err-devel libkrb5-devel libstdc++-devel perl-threads
BuildRequires: dos2unix flex gcc-c++ libssl-devel libstdc++-devel-static tzdata zlib-devel


%description
The gSOAP Web services development toolkit offers an XML to C/C++
language binding to ease the development of SOAP/XML Web services in C
and C/C++.


%package -n lib%name-devel
Summary: Devel libraries and headers for linking with gSOAP generated stubs
Group: Development/C

%description -n lib%name-devel
gSOAP libraries, headers and generators for linking with and creating
gSOAP generated stubs


%package -n lib%name-devel-static
Summary: Static devel libraries and headers for linking with gSOAP generated stubs
Group: Development/C
Requires: zlib-devel-static

%description -n lib%name-devel-static
gSOAP static libraries


%prep
%setup -q -n gsoap-2.8
%patch -p1

# a number of ~ files are distribute, but we do not want them
find . -name "*~" -exec rm {} \;

# we want all txt files to have unix end-of-line encoding
dos2unix README.txt LICENSE.txt NOTES.txt


%build
# patches change autoconf and automake files, so we must reconfigure
autoreconf --install --force

%configure --prefix=/usr

# dependencies are not declared properly
#make %{?_smp_mflags}
make

# during the build a number of files that we should not distribute are
# created in soapcpp2/samples/ (a doc directory), we must remove them
#find soapcpp2/samples/ -name ".deps" -prune -exec rm -rf {} \;

# we do not want to bother distributing samples for Windows or OS X
#rm -rf soapcpp2/samples/magic_VC
#rm -rf soapcpp2/samples/quote_VC
#rm -rf soapcpp2/samples/quote_MAC_ProjBuild

# samples do not need to be executable by default
#chmod a-x soapcpp2/samples/ssl/root.sh
#chmod a-x soapcpp2/samples/ssl/cacerts.pem


%install
make install DESTDIR=%buildroot


%check
make check


%files -n lib%name-devel-static
%_libdir/libgsoapck.a
%_libdir/libgsoapck++.a
%_libdir/libgsoap.a
%_libdir/libgsoapssl.a
%_libdir/libgsoapssl++.a
%_libdir/libgsoap++.a


%files -n lib%name-devel
%doc README.txt NOTES.txt LICENSE.txt
%_bindir/soapcpp2
%_bindir/wsdl2h
%_libdir/pkgconfig/gsoapck.pc
%_libdir/pkgconfig/gsoapck++.pc
%_libdir/pkgconfig/gsoap.pc
%_libdir/pkgconfig/gsoap++.pc
%_libdir/pkgconfig/gsoapssl.pc
%_libdir/pkgconfig/gsoapssl++.pc
%_includedir/stdsoap2.h
%dir %_datadir/gsoap
%dir %_datadir/gsoap/import
%_datadir/gsoap/import/c14n.h
%_datadir/gsoap/import/dom.h
%_datadir/gsoap/import/ds2.h
%_datadir/gsoap/import/ds.h
%_datadir/gsoap/import/README.txt
%_datadir/gsoap/import/soap12.h
%_datadir/gsoap/import/stldeque.h
%_datadir/gsoap/import/stl.h
%_datadir/gsoap/import/stllist.h
%_datadir/gsoap/import/stlset.h
%_datadir/gsoap/import/stlvector.h
%_datadir/gsoap/import/wsa3.h
%_datadir/gsoap/import/wsa4.h
%_datadir/gsoap/import/wsa5.h
%_datadir/gsoap/import/wsa.h
%_datadir/gsoap/import/WS-example.c
%_datadir/gsoap/import/WS-example.h
%_datadir/gsoap/import/WS-Header.h
%_datadir/gsoap/import/wsp.h
%_datadir/gsoap/import/wsrp.h
%_datadir/gsoap/import/wsse2.h
%_datadir/gsoap/import/wsse.h
%_datadir/gsoap/import/wsu.h
%_datadir/gsoap/import/xlink.h
%_datadir/gsoap/import/xmime4.h
%_datadir/gsoap/import/xmime5.h
%_datadir/gsoap/import/xmime.h
%_datadir/gsoap/import/xml.h
%_datadir/gsoap/import/xmlmime5.h
%_datadir/gsoap/import/xmlmime.h
%_datadir/gsoap/import/xop.h
%dir %_datadir/gsoap/WS
%_datadir/gsoap/WS/README.txt
%_datadir/gsoap/WS/WS-Addressing.xsd
%_datadir/gsoap/WS/WS-Addressing03.xsd
%_datadir/gsoap/WS/WS-Addressing04.xsd
%_datadir/gsoap/WS/WS-Addressing05.xsd
%_datadir/gsoap/WS/WS-Discovery.wsdl
%_datadir/gsoap/WS/WS-Enumeration.wsdl
%_datadir/gsoap/WS/WS-Policy.xsd
%_datadir/gsoap/WS/WS-Routing.xsd
%_datadir/gsoap/WS/WS-typemap.dat
%_datadir/gsoap/WS/discovery.xsd
%_datadir/gsoap/WS/ds.xsd
%_datadir/gsoap/WS/enumeration.xsd
%_datadir/gsoap/WS/typemap.dat
%_datadir/gsoap/WS/wsse.xsd
%_datadir/gsoap/WS/wsu.xsd
%dir %_datadir/gsoap/custom
%_datadir/gsoap/custom/README.txt
%_datadir/gsoap/custom/chrono_duration.cpp
%_datadir/gsoap/custom/chrono_duration.h
%_datadir/gsoap/custom/chrono_time_point.cpp
%_datadir/gsoap/custom/chrono_time_point.h
%_datadir/gsoap/custom/float128.c
%_datadir/gsoap/custom/float128.h
%_datadir/gsoap/custom/int128.c
%_datadir/gsoap/custom/int128.h
%_datadir/gsoap/custom/long_double.c
%_datadir/gsoap/custom/long_double.h
%_datadir/gsoap/custom/long_time.c
%_datadir/gsoap/custom/long_time.h
%_datadir/gsoap/custom/struct_timeval.c
%_datadir/gsoap/custom/struct_timeval.h
%_datadir/gsoap/custom/struct_tm.c
%_datadir/gsoap/custom/struct_tm.h
%_datadir/gsoap/custom/struct_tm_date.c
%_datadir/gsoap/custom/struct_tm_date.h
%dir %_datadir/gsoap/extras
%_datadir/gsoap/extras/README.txt
%_datadir/gsoap/extras/ckdb.c
%_datadir/gsoap/extras/ckdb.h
%_datadir/gsoap/extras/ckdbtest.c
%_datadir/gsoap/extras/ckdbtest.h
%_datadir/gsoap/extras/fault.cpp
%_datadir/gsoap/extras/logging.cpp
%_datadir/gsoap/extras/soapdefs.h
%dir %_datadir/gsoap/plugin
%_datadir/gsoap/plugin/README.txt
%_datadir/gsoap/plugin/cacerts.c
%_datadir/gsoap/plugin/cacerts.h
%_datadir/gsoap/plugin/httpda.c
%_datadir/gsoap/plugin/httpda.h
%_datadir/gsoap/plugin/httpdatest.c
%_datadir/gsoap/plugin/httpdatest.h
%_datadir/gsoap/plugin/httpform.c
%_datadir/gsoap/plugin/httpform.h
%_datadir/gsoap/plugin/httpget.c
%_datadir/gsoap/plugin/httpget.h
%_datadir/gsoap/plugin/httpgettest.c
%_datadir/gsoap/plugin/httpgettest.h
%_datadir/gsoap/plugin/httpmd5.c
%_datadir/gsoap/plugin/httpmd5.h
%_datadir/gsoap/plugin/httpmd5test.c
%_datadir/gsoap/plugin/httpmd5test.h
%_datadir/gsoap/plugin/httppost.c
%_datadir/gsoap/plugin/httppost.h
%_datadir/gsoap/plugin/logging.c
%_datadir/gsoap/plugin/logging.h
%_datadir/gsoap/plugin/md5evp.c
%_datadir/gsoap/plugin/md5evp.h
%_datadir/gsoap/plugin/plugin.c
%_datadir/gsoap/plugin/plugin.h
%_datadir/gsoap/plugin/smdevp.c
%_datadir/gsoap/plugin/smdevp.h
%_datadir/gsoap/plugin/threads.c
%_datadir/gsoap/plugin/threads.h
%_datadir/gsoap/plugin/wsaapi.c
%_datadir/gsoap/plugin/wsaapi.h
%_datadir/gsoap/plugin/wsse2api.c
%_datadir/gsoap/plugin/wsse2api.h
%_datadir/gsoap/plugin/wsseapi.c
%_datadir/gsoap/plugin/wsseapi.h
# Additions in 2.7.12-1
%_datadir/gsoap/WS/WS-ReliableMessaging.wsdl
%_datadir/gsoap/WS/WS-ReliableMessaging.xsd
%_datadir/gsoap/WS/reference-1.1.xsd
%_datadir/gsoap/WS/ws-reliability-1.1.xsd
%_datadir/gsoap/import/ref.h
%_datadir/gsoap/import/wsrm.h
%_datadir/gsoap/import/wsrm4.h
%_datadir/gsoap/import/wsrx.h
# Additions in 2.7.13-1
%_datadir/gsoap/import/stdstring.h
%_datadir/gsoap/import/xsd.h
%_datadir/gsoap/plugin/wsseapi.cpp
# Additions in 2.7.15
%_datadir/gsoap/plugin/httpposttest.h
%_datadir/gsoap/plugin/httpposttest.c
# Additions in 2.7.16-1
%_datadir/gsoap/custom/duration.c
%_datadir/gsoap/custom/duration.h
%_datadir/gsoap/plugin/wsrmapi.c
%_datadir/gsoap/plugin/wsrmapi.h
# Additions in 2.7.17-1
%_datadir/gsoap/WS/WS-Policy12.xsd
%_datadir/gsoap/WS/WS-SecurityPolicy.xsd
%_datadir/gsoap/import/wsse11.h
# Additions in 2.8.3-1
%_datadir/gsoap/WS/xenc.xsd
%_datadir/gsoap/import/xenc.h
%_datadir/gsoap/plugin/mecevp.c
%_datadir/gsoap/plugin/mecevp.h
# Additions in 2.8.4-1
%_datadir/gsoap/import/wsdd.h
%_datadir/gsoap/import/wsdx.h
%_datadir/gsoap/plugin/wsddapi.c
%_datadir/gsoap/plugin/wsddapi.h
# Additions in 2.8.7-1
%_datadir/gsoap/import/wsdd10.h
# Additions in 2.8.12-1
%_datadir/gsoap/WS/WS-SecureConversation.xsd
%_datadir/gsoap/WS/WS-Trust.wsdl
%_datadir/gsoap/WS/WS-Trust.xsd
%_datadir/gsoap/import/ser.h
%_datadir/gsoap/import/wsc.h
%_datadir/gsoap/import/wsrm5.h
%_datadir/gsoap/import/wsrx5.h
%_datadir/gsoap/import/wst.h
%_datadir/gsoap/import/wstx.h
# Additions in 2.8.16-1
%_datadir/gsoap/import/wsc2.h
%_datadir/gsoap/plugin/calcrest.h
# Additions in 2.8.17-1
%_datadir/gsoap/plugin/mq.c
%_datadir/gsoap/plugin/mq.h
# Additions in 2.8.21-1
%_datadir/gsoap/WS/LEGAL.txt
%_datadir/gsoap/WS/ws-bpel_abstract_common_base.xsd
%_datadir/gsoap/WS/ws-bpel_executable.xsd
%_datadir/gsoap/WS/ws-bpel_plnktype.xsd
%_datadir/gsoap/WS/ws-bpel_serviceref.xsd
%_datadir/gsoap/WS/ws-bpel_varprop.xsd
%_datadir/gsoap/import/plnk.h
%_datadir/gsoap/import/vprop.h
# Additions in 2.8.22-1
%_datadir/gsoap/import/wsdd5.h
%_datadir/gsoap/plugin/wsseapi-lite.c
%_datadir/gsoap/plugin/wsseapi-lite.h
# Additions in 2.8.23-1
%_datadir/gsoap/WS/oasis-sstc-saml-schema-assertion-1.1.xsd
%_datadir/gsoap/WS/saml-schema-assertion-2.0.xsd
%_datadir/gsoap/import/saml1.h
%_datadir/gsoap/import/saml2.h
# Additions in 2.8.31
%_datadir/gsoap/import/xenc2.h
# Additions in 2.8.34
%_datadir/gsoap/custom/qbytearray_base64.cpp
%_datadir/gsoap/custom/qbytearray_base64.h
%_datadir/gsoap/custom/qbytearray_hex.cpp
%_datadir/gsoap/custom/qbytearray_hex.h
%_datadir/gsoap/custom/qdate.cpp
%_datadir/gsoap/custom/qdate.h
%_datadir/gsoap/custom/qdatetime.cpp
%_datadir/gsoap/custom/qdatetime.h
%_datadir/gsoap/custom/qstring.cpp
%_datadir/gsoap/custom/qstring.h
%_datadir/gsoap/custom/qtime.cpp
%_datadir/gsoap/custom/qtime.h
%_datadir/gsoap/plugin/sessions.c
%_datadir/gsoap/plugin/sessions.h
# Additions in 2.8.35
%_datadir/gsoap/import/wsp_appliesto.h
%_datadir/gsoap/plugin/wstapi.c
%_datadir/gsoap/plugin/wstapi.h
# Additions in 2.8.67
%_datadir/gsoap/import/wst2.h
%_datadir/gsoap/import/wstx2.h
# Additions in 2.8.75
%_datadir/gsoap/plugin/httppipe.c
%_datadir/gsoap/plugin/httppipe.h
# Additions in 2.8.76
%_datadir/gsoap/plugin/curlapi.c
%_datadir/gsoap/plugin/curlapi.h

%changelog
