%def_disable snapshot

%define ver_major 1.16
%define api_ver 1.6
%define gst_api_ver 1.0

%def_enable wayland
%def_enable gtk_doc

Name: gstreamer-vaapi
Version: %ver_major.1
Release: alt1

Summary: GStreamer plugins to use VA-API video acceleration
Group: System/Libraries
License: LGPLv2.1
Url: http://gstreamer.freedesktop.org/modules/gstreamer-vaapi.html

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%name/%name-%version.tar.xz
%else
# VCS: git://anongit.freedesktop.org/gstreamer/gstreamer-vaapi
Source: %name/%name-%version.tar
%endif

%define glib_ver 2.28
%define gst_ver %version
%define va_ver 1.1

BuildRequires: glib2-devel >= %glib_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel >= %gst_ver
BuildRequires: libva-devel >= %va_ver
BuildRequires: libdrm-devel libudev-devel
BuildRequires: libGL-devel libXrandr-devel libXrender-devel
BuildRequires: gtk-doc
%{?_enable_wayland:BuildRequires: wayland-devel libwayland-client-devel libwayland-server-devel}

%description
A collection of plugins and helper libraries to use VA-API video
acceleration from GStreamer applications.

Includes elements for video decoding, display, encoding and post-processing
using VA API (subject to hardware limitations).

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for the collection of
plugins and helper libraries to use VA-API video acceleration from
GStreamer applications.

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable wayland}

%make_build

%install
%makeinstall_std

%files
%_libdir/gstreamer-%gst_api_ver/*.so
%doc AUTHORS NEWS README

%exclude %_libdir/gstreamer-%gst_api_ver/*.la

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name-plugins-%gst_api_ver/
%endif

%changelog
