%define _name gstreamer
%define ver_major 1.16
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%define api_ver 1.0

%def_enable gtk_doc
%def_disable debug
%def_disable libunwind
%def_disable libdw
%def_disable check

Name: %_name%api_ver
Version: %ver_major.1
Release: alt1

Summary: GStreamer streaming media framework runtime
License: LGPL
Group: System/Libraries
Url: http://gstreamer.freedesktop.org

Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz

Provides: %_name = %version-%release

Requires(pre): libcap-utils
Requires: lib%name = %version-%release

%define glib_ver 2.40.0

BuildRequires(pre): meson rpm-build-gir
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: flex gcc-c++ ghostscript-utils gtk-doc libcheck-devel libxml2-devel
BuildRequires: python-modules sgml-common transfig xml-utils gobject-introspection-devel
BuildRequires: libcap-devel libcap-utils
BuildRequires: bash-completion
%{?_enable_libunwind:BuildRequires: libunwind-devel}
%{?_enable_libdw:BuildRequires: libdw-devel}

%description
GStreamer is a streaming-media framework, based on graphs of filters which
operate on media data. Applications using this library can do anything
from real-time sound processing to playing videos, and just about anything
else media-related.  Its plugin-based architecture means that new data
types or processing capabilities can be added simply by installing new
plugins.

%package -n lib%name
Summary: Shared libraries of GStreamer
Group: System/Libraries
Provides: lib%_name = %version-%release

%description -n lib%name
This package contains the shared libraries of the GStreamer media framework

%package -n lib%name-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Provides: lib%_name-gir = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GStreamer library

%package devel
Summary: Development files for GStreamer streaming-media framework
Group: Development/C
Provides: %_name-devel = %version-%release
Requires: lib%name = %version-%release

%description devel
This package contains the libraries and header files necessary to
develop applications and plugins for GStreamer

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Provides: lib%_name-gir-devel = %version-%release
Requires: lib%name-gir = %version-%release %name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GStreamer library

%package devel-doc
Summary: Development documentation for GStreamer
Group: Development/C
BuildArch: noarch
Provides: %_name-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for GStreamer

%package utils
Summary: GStreamer utilities
Group: System/Libraries
Provides: %_name-utils = %version-%release
Requires: lib%name = %version-%release

%description utils
This package contains some utilities used to register, analyze, and run
Gstreamer plugins.

%prep
%setup -n %_name-%version

%build
%ifarch e2k
# till lcc ~1.23
export LIBS=-lcxa
%endif
%meson \
	-Dpackage-name="GStreamer" \
	-Dpackage-origin=%name \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_debug:-Dgst_debug=true} \
	-Dptp-helper-permissions="capabilities"
%meson_build

%install
%meson_install
%find_lang %_name-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%post
setcap cap_net_bind_service,cap_net_admin+ep %_libexecdir/%_name-%api_ver/gst-ptp-helper 2>/dev/null ||:

%files -f %_name-%api_ver.lang
%dir %_libexecdir/%_name-%api_ver
%_libexecdir/%_name-%api_ver/gst-plugin-scanner
%_libexecdir/%_name-%api_ver/gst-ptp-helper
%dir %_libdir/%_name-%api_ver
%_libdir/%_name-%api_ver/*.so
%doc AUTHORS NEWS README RELEASE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/Gst-%api_ver.typelib
%_typelibdir/GstBase-%api_ver.typelib
%_typelibdir/GstCheck-%api_ver.typelib
%_typelibdir/GstController-%api_ver.typelib
%_typelibdir/GstNet-%api_ver.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*
%if_enabled debug
%_datadir/gdb/auto-load/%_libdir/lib%name-%api_ver.so.*-gdb.py
%_datadir/glib-2.0/gdb/glib_gobject_helper.py
%_datadir/glib-2.0/gdb/gst_gdb.py
%endif

%files -n lib%name-gir-devel
%_girdir/Gst-%api_ver.gir
%_girdir/GstBase-%api_ver.gir
%_girdir/GstCheck-%api_ver.gir
%_girdir/GstController-%api_ver.gir
%_girdir/GstNet-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/*

%files utils
%_bindir/*
%_man1dir/*
# bash-completions
%_libexecdir/%_name-%api_ver/gst-completion-helper
%_datadir/bash-completion/completions/gst-inspect-%api_ver
%_datadir/bash-completion/completions/gst-launch-%api_ver
%_datadir/bash-completion/helpers/gst

%changelog
