%def_disable snapshot
%def_with mkpdf
%def_disable check

Name: gtk-doc
Version: 1.29
Release: alt2

Summary: API documentation generation tool for GTK+ and GNOME
Group: Development/Other
License: %gpl2plus
Url: http://www.gtk.org/gtk-doc/

%define pkgdocdir %_docdir/%name-%version
%define python_ver 2.7
%define dblatex_ver 0.3.10

Requires: python >= %python_ver
Requires: sgml-common >= 0.6.3-alt11
Requires: docbook-dtds >= 4.3-alt1
Requires: docbook-style-xsl
Requires: libxml2 >= 2.3.6
Requires: xsltproc
%{?_with_mkpdf:Requires: highlight}
# for SGML
Requires: openjade >= 1.3.1
Requires: docbook-style-dsssl

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%version/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

Provides: python3(gtkdoc)

%add_python3_path %_datadir/%name/python/gtkdoc

BuildRequires(pre): rpm-build-python3 rpm-build-licenses
BuildRequires: python3-devel >= %python_ver
BuildRequires: docbook-dtds xml-common xml-utils
BuildRequires: docbook-dtds >= 1.0-alt7
BuildRequires: docbook-style-xsl bc
%{?_with_mkpdf:BuildRequires: yelp-tools highlight dblatex >= %dblatex_ver}
# for SGML
BuildRequires: docbook-style-dsssl
BuildRequires: openjade >= 1.3.1
%{?_enable_check:BuildRequires: glib2-devel python-module-mock}

%description
%name is a tool for generating API reference documentation.
it is used for generating the documentation for GTK+, GLib
and GNOME.

%package mkpdf
Summary: PDF converter for %name
Group: Development/Other
Requires: %name = %version-%release
Requires: dblatex >= %dblatex_ver

%description mkpdf
%name is a tool for generating API reference documentation.
it is used for generating the documentation for GTK+, GLib
and GNOME.

This package provides utility for saving documentation in PDF format

%package manual
Summary: Manual for gtk-doc
Group: Development/Other
License: %fdl

%description manual
Manual for gtk-doc, a tool for generating API reference documentation
used by GTK+, GLib and GNOME.

%prep
%setup
# make cmake files arch-independent
subst 's/libdir/datadir/' buildsystems/cmake/Makefile.am

# Move this doc file to avoid name collisions
mv doc/README doc/README.docs
rm -f examples/*~

%build
%autoreconf
%undefine _configure_target
export PYTHON=%_bindir/python3
export ac_cv_path_JADE=%_bindir/openjade
export ac_cv_path_XSLTPROC=%_bindir/xsltproc
%{?_with_mkpdf:export ac_cv_path_DBLATEX=%_bindir/dblatex}
%configure \
    --with-xml-catalog=%_sysconfdir/xml/catalog \
    --docdir=%pkgdocdir \
    %{?_with_mkpdf:--with-highlight=highlight}
%make_build

%install
%make_install DESTDIR=%buildroot pkgconfigdir=%_datadir/pkgconfig install
install -d -m755 %buildroot%_datadir/gtk-doc/html
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d/
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^%_datadir/(gtk-doc|gnome|bonobo)/html/.
EOF

%find_lang --with-gnome gtk-doc-manual

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS ChangeLog MAINTAINERS NEWS README TODO doc/* \
    %buildroot%pkgdocdir/
bzip2 -9 %buildroot%pkgdocdir/ChangeLog
ln -s %_licensedir/GPL-2 %buildroot%pkgdocdir/COPYING
ln -s %_licensedir/FDL-1.1 %buildroot%pkgdocdir/COPYING-DOCS
cp -a examples %buildroot%pkgdocdir/

%check
%make check

%files
%_bindir/*
%{?_with_mkpdf:%exclude %_bindir/gtkdoc-mkpdf}
%_datadir/%name/
%_datadir/pkgconfig/%name.pc
%_datadir/aclocal/%name.m4
%dir %_datadir/cmake/GtkDoc
%_datadir/cmake/GtkDoc/*.cmake
%_sysconfdir/buildreqs/files/ignore.d/*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/COPYING
%pkgdocdir/ChangeLog.bz2
%pkgdocdir/MAINTAINERS
%pkgdocdir/NEWS
%pkgdocdir/README*
%pkgdocdir/TODO
%pkgdocdir/*.txt
%pkgdocdir/examples

%if_with mkpdf
%files mkpdf
%_bindir/gtkdoc-mkpdf
%endif

%files manual -f gtk-doc-manual.lang
%dir %pkgdocdir
%pkgdocdir/COPYING-DOCS

%changelog
