%def_disable snapshot
%def_enable introspection

%define ver_major 12.0
%define api_ver 2.90
%define unicode_ver 12.0.0

Name: gucharmap
Version: %ver_major.1
Release: alt1

Summary: gucharmap is a featureful Unicode character map
Group: Text tools
License: %gpl3plus
Url: https://wiki.gnome.org/Gucharmap

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

# From configure.ac
%define glib_ver 2.32.0
%define gtk_ver 3.4.0

Requires: lib%name = %version-%release
Requires: dconf gnome-icon-theme

BuildPreReq: rpm-build-gnome rpm-build-licenses
# From configure.ac
BuildPreReq: intltool >= 0.40.0
BuildPreReq: unicode-ucd >= %unicode_ver unzip
BuildRequires: gnome-common desktop-file-utils appdata-tools
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildRequires: yelp-tools itstool
BuildPreReq: gtk-doc >= 1.0
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel}

%description
This package provides a featureful Unicode character map for GNOME.

%package -n lib%name
Summary: Shared library needed to run %name
Group: System/Libraries

%description -n lib%name
This package provides shared library for programs that show character maps
(including Gucharmap and a character map applet for the GNOME panel).

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains headers and libraries needed to compile
applications against lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GNOME Unicode character map library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Unicode character map library

%prep
%setup

%build
%autoreconf
export LDFLAGS="$LDFLAGS -ldl"
%configure \
    --disable-static \
    --disable-schemas-compile \
    %{subst_enable introspection} \
    --with-unicode-data=%_datadir/unicode/ucd
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.Charmap.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Charmap.enums.xml
%_datadir/metainfo/%name.appdata.xml
%doc AUTHORS NEWS TODO COPYING.UNICODE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Gucharmap-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Gucharmap-%api_ver.gir
%endif

%changelog
