%def_with qt5

Name:     gwenhywfar
Version:  5.4.1
Release:  alt1

Summary:  A multi-platform helper library for other libraries
License:  LGPL-2.1+
Group:    System/Libraries
URL:      http://www2.aquamaniac.de/sites/download/packages.php
# VCS:    http://git.aqbanking.de/git/gwenhywfar.git

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
Patch2:   %name-fix-build-with-qt5.patch

BuildRequires: gcc-c++ glibc-devel graphviz libcom_err-devel 
BuildRequires: libgnutls-devel libssl-devel tzdata
BuildRequires: libqt4-devel
BuildRequires: libgtk+2-devel
BuildRequires: libgtk+3-devel
%if_with qt5
BuildRequires: qt5-base-devel qt5-tools
%endif
BuildRequires: zlib-devel libgcrypt-devel ncurses-devel
BuildRequires: ca-certificates

Requires: ca-certificates

%description
This is Gwenhywfar, a multi-platform helper library for networking and
security applications and libraries. It is heavily used by libchipcard
www.libchipcard.de and OpenHBCI-TNG (The Next Generation)
www.openhbci.de.

Check http://www.freesource.info/wiki/Altlinux/Policy/TLS
for ALT Linux TLS/SSL policy

%package -n lib%name
Summary: A multi-platform helper library for other libraries
Group:    System/Libraries

%description -n lib%name
This is Gwenhywfar, a multi-platform helper library for networking and
security applications and libraries. It is heavily used by libchipcard
www.libchipcard.de and OpenHBCI-TNG (The Next Generation)
www.openhbci.de.

Check http://www.freesource.info/wiki/Altlinux/Policy/TLS
for ALT Linux TLS/SSL policy

%package  -n lib%name-gtk2
Summary:  Gwenhywfar support for GTK+ 2.x
Group:    System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gtk2
Gwenhywfar support for GTK+ 2.x.

%package  -n lib%name-gtk3
Summary:  Gwenhywfar support for GTK+ 3.x
Group:    System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gtk3
Gwenhywfar support for GTK+ 3.x.

%package  -n lib%name-qt4
Summary:  Gwenhywfar support for Qt4
Group:    System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-qt4
Gwenhywfar support for Qt4

%if_with qt5
%package  -n lib%name-qt5
Summary:  Gwenhywfar support for Qt5
Group:    System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-qt5
Gwenhywfar support for Qt5
%endif

%package  -n lib%name-devel
Summary:  Gwenhywfar development kit
Group:    Development/C
Requires: lib%name = %version-%release
Requires: lib%name-gtk2 = %version-%release
Requires: lib%name-qt4  = %version-%release
%if_with qt5
Requires: lib%name-qt5  = %version-%release
%endif

%description -n lib%name-devel
This package contains gwenhywfar-config and header files for writing and
compiling programs using Gwenhywfar.

%prep
%setup
%patch2 -p1

%build
%undefine _configure_gettext
%autoreconf
%if_with qt5
export PATH=$PATH:%_qt5_bindir
%endif
%configure \
	--disable-static \
%if_with qt5
	--with-guis="gtk2 gtk3 qt4 qt5" \
	--with-qt5-qmake=%_bindir/qmake-qt5 \
	--with-qt5-moc=%_bindir/moc-qt5 \
	--with-qt5-uic=%_bindir/uic-qt5 \
%else
	--with-guis="gtk2 gtk3 qt4" \
%endif
	--with-qt4-libs="%_libdir"

%make_build

%install
%makeinstall_std
%find_lang %name

# Use system-wide ca-certificates
rm -f %buildroot%_datadir/gwenhywfar/ca-bundle.crt
ln -s %_datadir/ca-certificates/ca-bundle.crt %buildroot%_datadir/gwenhywfar/ca-bundle.crt

%files -n lib%name -f %name.lang
%doc AUTHORS README TODO
%_bindir/gct-tool
%_bindir/gsa
%_libdir/*.so.*
%exclude %_libdir/libgwengui-gtk2.so.*
%exclude %_libdir/libgwengui-gtk3.so.*
%exclude %_libdir/libgwengui-qt4.so.*
%if_with qt5
%exclude %_libdir/libgwengui-qt5.so.*
%endif
%_libdir/%name/
%_datadir/gwenhywfar/ca-bundle.crt
%_datadir/gwenhywfar/dialogs/*.dlg

%files -n lib%name-gtk2
%_libdir/libgwengui-gtk2.so.*

%files -n lib%name-gtk3
%_libdir/libgwengui-gtk3.so.*

%files -n lib%name-qt4
%_libdir/libgwengui-qt4.so.*

%if_with qt5
%files -n lib%name-qt5
%_libdir/libgwengui-qt5.so.*
%endif

%files -n lib%name-devel
%_bindir/%name-config
%_bindir/xmlmerge
%_bindir/mklistdoc
%_bindir/typemaker
%_bindir/typemaker2
%_libdir/*.so
%_includedir/gwenhywfar5/
%_pkgconfigdir/*
%_datadir/%name/typemaker2/*
%_datadir/aclocal/gwenhywfar.m4
%_libdir/cmake/*

%changelog
