# $Id: hping2.spec,v 1.7 2004/02/13 10:37:33 homyakov Exp $

%define beta	rc2

Name:		hping2
Version:	2.0.0
Release:	alt4.%beta.qa3
Packager:	Igor Homyakov <homyakov at altlinux dot ru>

Provides:	hping = %version
Obsoletes:	hping

%define srcname	 %name-%beta

Summary: hping2 is a network tool able to send custom ICMP/UDP/TCP packets
Summary(ru_RU.KOI8-R):    ICMP/UDP/TCP 
License: GPL
Group: Security/Networking
Url: http://www.hping.org
Source: hping%version-%beta.tar.gz
Patch:  hping2-rc2-alt-cleanup.patch

# Automatically added by buildreq on Wed Feb 11 2004
BuildRequires: libpcap-devel

%description
hping2 is a network tool able to send custom ICMP/UDP/TCP
packets and to display target replies like ping do with
ICMP replies. hping2 handle fragmentation, arbitrary packet
body and size and can be used in order to transfer files
under supported protocols. Using hping2 you are able at
least to perform the following jobs:

      - Test firewall rules
      - [spoofed] port scanning
      - Test net performance using differents protocols,
          packet size, TOS (type of service) and fragmentation.
      - Path MTU discovery
      - Files trasfering even between really fascist firewall rules.
      - Traceroute like under different protocols.
      - Firewalk like usage.
      - Remote OS fingerprint.
      - TCP/IP stack auditing.
      - A lot of others.

%description -l ru_RU.KOI8-R
%name    ICMP/UDP/TCP , 
    ..     
       TCP/IP
  -    
  -  
  -   
  -    TCP/IP
  -     
  -   ...

%prep

%setup -q -n %srcname

%patch -p1

%build
%configure --force-libpcap

%make_build

%install
install -m700 -D %name        %buildroot%_sbindir/%name
install -m644 -D docs/%name.8 %buildroot%_man8dir/%name.8

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories 
# usually don't belong in releases. 
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find $RPM_BUILD_ROOT -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \;
# hack if it is installed as doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; || :

%files
%_sbindir/*
%_mandir/man8/*
%doc README INSTALL AUTHORS BUGS CHANGES KNOWN-BUGS NEWS TODO docs/
%doc docs/ utils/

%changelog
