# Python scripting interface disabled by default since 2018.0.0
%def_enable hsi
# lapack support disabled by default
%def_disable lapack

Name: hugin
Version: 2019.0.0
Release: alt1

Summary: hugin - Goal: an easy to use cross-platform GUI for Panorama Tools.
Group: Graphics
License: GPLv2+
Url: http://hugin.sourceforge.net/

Source: %name-%version.tar
Patch1: Add-translations-in-desktop-files.patch
Patch2: hugin-2019.0.0-fc-exiv2-0.27.patch

BuildPreReq: libpano13-devel boost-devel >= 1.34 libwxGTK3.0-devel >= 3.0.0
BuildPreReq: boost-thread-devel >= 1.34 gcc-c++ gcc-fortran
BuildRequires: boost-devel boost-thread-devel boost-datetime-devel boost-regex-devel
BuildRequires: boost-filesystem-devel boost-iostreams-devel boost-system-devel
BuildRequires: boost-signals-devel libglew-devel libXi-devel libXmu-devel
BuildRequires: libgtk+2-devel libjpeg-devel libpano13-devel perl-podlators
BuildRequires: libpng-devel libstdc++-devel libtiff-devel
BuildRequires: zlib-devel libpango-devel zip cmake openexr-devel libexiv2-devel libtclap-devel
BuildRequires: liblensfun-devel libvigra-devel libgomp-devel libfftw3-devel libsqlite3-devel
BuildRequires: libflann-devel
%if_enabled hsi
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel swig
%add_python3_path %_datadir/%name/data/plugins*
%endif
%{?_enable_lapack:BuildRequires: liblapack-devel}
BuildRequires: desktop-file-utils
BuildRequires: liblcms2-devel

Requires: enblend >= 3.2 libpano13 libwxGTK3.0 >= 3.0.0  autopano-sift-C perl-Image-ExifTool make

%description
With hugin you can assemble a mosaic of photographs into a complete immersive
panorama, stitch any series of overlapping pictures and much more.

%prep
%setup
%patch1 -p2
%patch2 -p1 -b .exiv2

# fix shebang for python3
find src/hugin_script_interface/ -name "*.py" -print0| xargs -r0 sed -i "s@/usr/bin/env python@/usr/bin/python3@" --

%build
# reenable RPTHs because libraries in private subdirectory
%cmake -DINSTALL_XRC_DIR="/usr/share/hugin/xrc" \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	%{?_enable_hsi:-DBUILD_HSI:BOOL=ON} \
	%{?_enable_lapack:-DENABLE_LAPACK:BOOL=ON} \
	-DPYTHON_EXECUTABLE=%__python3
%cmake_build

%install
%cmakeinstall_std
%find_lang --output=%name.lang %name nona_gui
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_datadir/pixmaps/%name.png
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_niconsdir/%name.png

for file in hugin PTBatcherGUI calibrate_lens_gui pto_gen; do
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Photography \
	%buildroot%_desktopdir/$file.desktop
done

%files -f %name.lang
%doc AUTHORS README
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%name/
%_datadir/pixmaps/*
%_datadir/mime/packages/hugin.xml
%_libdir/%name/
%{?_enable_hsi:%python3_sitelibdir/*}
%_niconsdir/*
%_iconsdir/gnome/48x48/mimetypes/gnome-mime-application-x-ptoptimizer-script.png
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/*
%_datadir/appdata/PTBatcherGUI.appdata.xml
%_datadir/appdata/calibrate_lens_gui.appdata.xml
%_datadir/appdata/%name.appdata.xml

%changelog
