Name: ipaudit
Version: 1.0
Release: alt1rc9.qa1
Copyright: GPL
Group: Monitoring
Source: %{name}-%{version}rc9.tar.gz
Patch: ipaudit-errno.patch
Summary: IPAudit monitors network activity on a network by host, protocol and port.
Packager: Ilya Mashkin <oddity@altlinux.ru>
Url: http://ipaudit.sourceforge.net/
BuildRoot: /var/tmp/%{name}-%{version}-root
BuildRequires: libpcap-devel


%description
IPAUDIT listens to a network device in promiscuis mode, and records
of every 'connection', each conversation between two ip addresses.  A unique
connection is determined by the ip addresses of the two machines, the
protocol used between them and the port numbers (if they are communicating
via udp or tcp).

It uses a hash table to keep track of the number of bytes and packets
in both directions.  When IPAUDIT receives a signal SIGTERM (kill)
or SIGINT (kill -2, usually the same as a Control-C), it stops collecting
data and write the tabulated results.
  
%prep
%setup -q -n %{name}-%{version}rc9
#patch -p 1

%build
./configure --prefix=/usr
%make_build
# all

%install
make install DESTDIR=%buildroot

#mkdir %buildroot/usr/share/man
#mkdir %buildroot%_man1dir
#mkdir %buildroot%_man8dir

%__install -pD -m444 %buildroot/usr/man/man1/total.1 %buildroot%_man1dir/total.1
#rmdir %buildroot/usr/man/man1/
%__install -pD -m444 %buildroot/usr/man/man8/%name.8 %buildroot%_man8dir/%name.8
%__install -pD -m444 %buildroot/usr/man/man8/ipstrings.8 %buildroot%_man8dir/ipstrings.8
#rmdir %buildroot/usr/man/man8/

%files
%doc README
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man8dir/*


%changelog
