Name: iputils
%define timestamp 20190709
Version: %timestamp
Release: alt3

Summary: Utilities for IPv4/IPv6 networking
License: BSD-3-Clause and GPL-2.0+ and Rdisc
Group: Networking/Other
Url: https://github.com/iputils/iputils

Source0: %name-%version.tar
Source1: ping.control
Source2: ninfod.init
Patch: %name-%version-%release.patch

Conflicts: netkit-base

Requires(pre): shadow-utils
Requires(pre): control >= 0.8.0-alt1
Requires: /var/resolv

BuildRequires(pre): meson

BuildRequires: libcap-devel
BuildRequires: libsysfs-devel libssl-devel
BuildRequires: libidn2-devel
BuildRequires: docbook5-style-xsl xsltproc

%define _unpackaged_files_terminate_build 1

%define sysctl_conf_file %_sysctldir/70-iputils.conf
%define ping_real_dir %_usr/libexec/ping

%description
The iputils package contains basic utilities for monitoring a network:
+ clockdiff - measures clock difference;
+ ping/ping6 - sends ICMP ECHO_REQUEST packets to network hosts;
+ arping - ping by ARP packets;
+ rdisc - classic router discovery daemon;
+ tracepath/tracepath6 - traces path to destination discovering MTU
along this path.

%package -n ninfod
Group: Networking/Other
Summary: Node Information Query Daemon
License: BSD-3-Clause

%description -n ninfod
Node Information Query (RFC4620) daemon. Responds to IPv6 Node Information
Queries.

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing -Wstrict-prototypes
%ifarch s390 s390x
	%add_optflags -fPIE
%else
	%add_optflags -fpie
%endif

export LDFLAGS='-pie'
%meson \
	-DBUILD_TFTPD=false \
	-Dsystemdunitdir=%_unitdir \
	-DNO_SETCAP_OR_SUID=true \
	-DUSE_CAP=true \
	-DUSE_IDN=true \
	-DUSE_CRYPTO=openssl \
	-DUSE_GETTEXT=false

%meson_build -v

%install
%meson_install
mkdir -p %buildroot%ping_real_dir/
mv %buildroot%_bindir/ping %buildroot%ping_real_dir/
ln -s %ping_real_dir/ping %buildroot%_bindir/ping
ln -s %ping_real_dir/ping %buildroot%_bindir/ping6

install -pD -m755 %SOURCE1 %buildroot%_controldir/ping

mkdir -p %buildroot%_sysctldir/
touch %buildroot%sysctl_conf_file

install -pD -m755 %SOURCE2 %buildroot%_initdir/ninfod

ln -s tracepath %buildroot%_bindir/tracepath6
# for backward compatibility
mkdir -p %buildroot/bin/
for p in ping ping6 tracepath tracepath6; do
	ln -s %_bindir/"$p"  %buildroot/bin/"$p"
done

%pre
groupadd -r -f iputils ||:
useradd -r -g iputils -d /dev/null -s /dev/null -n iputils >/dev/null 2>&1 ||:
groupadd -r -f netadmin ||:

%pre_control ping

%post
# net.ipv4.ping_group_range controls both IPv4 and IPv6 sockets
if [ ! -e %sysctl_conf_file ]; then
	ALLOW_GID="$(getent group iputils | cut -f3 -d:)" ||:
	if [ -n "$ALLOW_GID" ]; then
		cat >%_sysctldir/70-iputils.conf <<EOF
# Allow ping socket creation for group iputils
net.ipv4.ping_group_range = $ALLOW_GID $ALLOW_GID
EOF
		sysctl -p %sysctl_conf_file ||:
	fi
fi

%post_control ping

# There is no rdisk init script
if sd_booted; then
	%post_service rdisc
fi

%preun
if sd_booted; then
	%preun_service rdisc
fi

%post -n ninfod
%post_service ninfod

%preun -n ninfod
%preun_service ninfod

%files
%config %_controldir/ping
%attr(700,root,netadmin) %verify(not mode) %dir %ping_real_dir/
%attr(2711,root,iputils) %ping_real_dir/ping
%ghost %config %sysctl_conf_file
/bin/*
%_bindir/*
%_unitdir/rdisc.service
%_sbindir/*
%_mandir/man?/*
%exclude %_sbindir/ninfod
%exclude %_man8dir/ninfod.*

%files -n ninfod
%doc ninfod/COPYING
%_unitdir/ninfod.service
%_initdir/ninfod
%_sbindir/ninfod
%_man8dir/ninfod.*

%changelog
