Summary: iSCSI kernel module and utilities
Name: iscsitarget
%define module_name %name
Version: 1.4.20.2
Release: alt2
License: %gpl2only
Group: System/Configuration/Networking
Source: %name-%version.tar
Patch: %name-%version-alt.patch
URL: http://%name.sourceforge.net/
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>

BuildRequires: kernel-build-tools rpm-build-licenses

# Automatically added by buildreq on Fri Jun 08 2007
BuildRequires: libssl-devel

%description
The %name package provides server kernel modules for the iSCSI
protocol, as well as utilities to configure the kernel modules. iSCSI
is a protocol that conveys SCSI protocol related command and data over
networks, especially over IP.


%package utils
Group: System/Configuration/Networking
Summary: iSCSI utilities

%description utils
iSCSI is a protocol that conveys SCSI protocol related command and data
over networks, especially over IP.
This package provides utils to create an iSCSI storage.


%package -n kernel-source-%module_name
Summary: Linux %module_name modules sources
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%module_name
This package contains sources for %module_name kernel module.


%prep
%setup
%patch -p1


%build
export CFLAGS="%optflags"
%make_build -C usr
bzip2 --best --keep --force ChangeLog


%install
%make_install DESTDIR=%buildroot install-usr install-man install-initd install-etc

rm -rf kernel-source-%module_name-%version
install -d -m 0755 kernel-source-%module_name-%version/{include,kernel}
install -m 0644 Makefile kernel-source-%module_name-%version/Makefile
install -m 0644 include/* kernel-source-%module_name-%version/include/
install -m 0644 kernel/* kernel-source-%module_name-%version/kernel/
install -d -m 0755 %buildroot%_usrsrc/kernel/sources
tar -c kernel-source-%module_name-%version | bzip2 -9c > \
    %buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%version.tar.bz2


%post utils
%post_service iscsi-target

%preun utils
%preun_service iscsi-target

%files utils
%doc ChangeLog.* README* etc/initiators.* etc/ietd.conf
%_initdir/*
%config %_sysconfdir/iet/ietd.conf
%config %_sysconfdir/iet/initiators.*
%config %_sysconfdir/iet/targets.*
%_sbindir/*
%_man5dir/*
%_man8dir/*


%files -n kernel-source-%module_name
%_usrsrc/kernel/sources/*.tar.bz2


%changelog
