%def_enable firewire

Name: jack-audio-connection-kit
Version: 1.9.12
Release: alt2
Epoch: 1

Summary: The Jack Audio Connection Kit
License: GPLv2 and GPLv2+ and LGPLv2+
Group: Sound

Url: http://www.jackaudio.org
Source0: https://github.com/jackaudio/jack2/releases/download/v%version/jack2-%version.tar.gz
Source2: %name-script.pa
Source3: %name-limits.conf
Patch: jack-realtime-compat.patch

Provides: jackd = %epoch:%version-%release
Obsoletes: jackd < %epoch:%version

BuildRequires: doxygen gcc-c++ libalsa-devel libcelt-devel libdbus-devel libexpat-devel libffado-devel
BuildRequires: libncurses-devel libreadline-devel libsamplerate-devel libsndfile-devel python-modules-compiler
BuildRequires: python-modules-email python-modules-encodings python-modules-logging
# FIXME: freebob seems obsoleted by ffado
%{?_enable_firewire:BuildRequires: libfreebob-devel}

%description
JACK is a low-latency audio server, written primarily for the Linux
operating system. It can connect a number of different applications to
an audio device, as well as allowing them to share audio between
themselves. Its clients can run in their own processes (i.e. as a
normal application), or can they can run within a JACK server (i.e. a
"plugin").

JACK is different from other audio server efforts in that it has been
designed from the ground up to be suitable for professional audio
work. This means that it focuses on two key areas: synchronous
execution of all clients, and low latency operation.

%package -n libjack
Summary: Shared libraries to run JACK
Group: System/Libraries

%description -n libjack
This package contains the shared libraries required for %name

%package -n libjack-devel
Summary: Development files for JACK
Group: Development/C++
Provides: jackit-devel = %epoch:%version-%release jackit-devel-doc = %epoch:%version-%release
Obsoletes: jackit-devel < %epoch:%version jackit-devel-doc < %epoch:%version

%description -n libjack-devel
This package includes the development libraries and header files
necessary for developing programs which will use JACK

%package utils
Summary: Utilities for JACK
Group: Sound
Requires: %name = %EVR
Provides: jackit-utils = %epoch:%version-%release
Obsoletes: jackit-utils < %epoch:%version

%description utils
Utilities that control and interact with the JACK server-jackd

%prep
%setup -n jack2-%version
%patch -p1

%build
# Some plugins use C++ and need lcxa. It can't be loaded
# dynamically, so all binaries should be linked with it.
%ifarch %e2k
cc --version | grep -q '^lcc:1.21' && export LINKFLAGS+=" -lcxa"
%endif
./waf configure \
	--prefix=%_prefix \
	--libdir=/%_libdir \
	--doxygen \
	--alsa \
	--dbus \
	--classic \
	%{?_enable_firewire:--firewire --freebob}
./waf build -j${NPROCS:-%__nprocs}

%install
./waf --destdir=%buildroot install
install -pDm644 %SOURCE2 %buildroot%_sysconfdir/pulse/%name.pa
install -pDm644 %SOURCE3 %buildroot%_sysconfdir/security/limits.d/99-%name.conf

mkdir -p %buildroot%_datadir/doc/%name
mv %buildroot%_datadir/jack-audio-connection-kit/reference/html/* %buildroot%_datadir/doc/%name/

export RPM_LD_PRELOAD_jack='%buildroot%_libdir/libjack.so %buildroot%_libdir/libjacknet.so %buildroot%_libdir/libjackserver.so'
export RPM_FILES_TO_LD_PRELOAD_jack=%_libdir/jack/*.so
%set_verify_elf_method unresolved=strict

%files
%_sysconfdir/pulse/%name.pa
%_sysconfdir/security/limits.d/99-%name.conf
%_bindir/jackd*
%_bindir/jack_load
%_bindir/jack_unload
%_bindir/jack_connect
%_bindir/jack_disconnect
%_bindir/jack_lsp
%_libdir/libjackserver.so.*
%_libdir/libjacknet.so.*
%dir %_libdir/jack
%_libdir/jack/*.so
%_datadir/dbus-1/services/org.jackaudio.service
%_man1dir/jackd*.1*
%_man1dir/jack_load.1*
%_man1dir/jack_unload.1*
%_man1dir/jack_connect.1*
%_man1dir/jack_disconnect.1*
%_man1dir/jack_lsp.1*

%files -n libjack
%_libdir/libjack.so.*

%files -n libjack-devel
%_includedir/jack
%_libdir/libjack.so
%_libdir/libjacknet.so
%_libdir/libjackserver.so
%_pkgconfigdir/*.pc
%_datadir/doc/%name

%files utils
%_bindir/alsa_in
%_bindir/alsa_out
%exclude %_bindir/jack_load
%exclude %_bindir/jack_unload
%exclude %_bindir/jack_connect
%exclude %_bindir/jack_disconnect
%exclude %_bindir/jack_lsp
%_bindir/jack_*
%exclude %_man1dir/jack_load.1*
%exclude %_man1dir/jack_unload.1*
%exclude %_man1dir/jack_connect.1*
%exclude %_man1dir/jack_disconnect.1*
%exclude %_man1dir/jack_lsp.1*
%_man1dir/alsa_in.1*
%_man1dir/alsa_out.1*
%_man1dir/jack_*.1*
%_man1dir/jackrec.1*

%changelog
