%define rname kguiaddons
%def_disable python
%if_enabled python
%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.70.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 utilities for graphical user interfaces
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar

# Automatically added by buildreq on Fri Dec 26 2014 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXi-devel libXrender-devel libXt-devel libcloog-isl4 libqt5-core libqt5-gui libqt5-test libqt5-widgets libqt5-x11extras libstdc++-devel libxcb-devel pkg-config python-base qt5-base-devel ruby ruby-stdlibs xorg-kbproto-devel xorg-xf86miscproto-devel xorg-xproto-devel
#BuildRequires: extra-cmake-modules gcc-c++ libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libxkbfile-devel python-module-google qt5-x11extras-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
%if_enabled python
BuildRequires(pre): python3-module-sip-devel python-module-sip-devel
BuildRequires: python-module-PyQt5-devel
%endif
BuildRequires: extra-cmake-modules gcc-c++ qt5-x11extras-devel
BuildRequires: libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel
BuildRequires: libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXtst-devel
BuildRequires: libXv-devel libXxf86misc-devel libXxf86vm-devel libxkbfile-devel

%description
The KDE GUI addons provide utilities for graphical user interfaces in the areas
of colors, fonts, text, images, keyboard input.

%package common
Summary: %name common package
Group: System/Configuration/Other
#BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5guiaddons
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5guiaddons
KF5 library

%if_enabled python
%package -n python-module-%rname
Summary: Python bindings for KGuiAddons
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
Requires: python-module-pykf5
Requires: python-module-sip = %sipver2
%description -n python-module-%rname
Python bindings for KGuiAddons

%package -n python-module-%rname-devel
Summary: Sip files for python-module-%rname
Group: Development/Python
BuildArch: noarch
%description -n python-module-%rname-devel
Sip files for python-module-%rname

%package -n python3-module-%rname
Summary: Python3 bindings for KGuiAddons
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KGuiAddons

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version

%build
%K5build

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


%files common -f %name.lang
%doc COPYING.LIB README.md
%dir %_K5plug/kf5/kguiaddons/
%dir %_K5plug/kf5/kguiaddons/kmodifierkey/

%files devel
%_K5inc/kguiaddons_version.h
%_K5inc/KGuiAddons/
%_K5link/lib*.so
%_K5lib/cmake/KF5GuiAddons
%_K5archdata/mkspecs/modules/qt_KGuiAddons.pri

%files -n libkf5guiaddons
%_K5lib/libKF5GuiAddons.so.*
%_K5plug/kf5/kguiaddons/kmodifierkey/kmodifierkey_*.so

%if_enabled python
%files -n python-module-%rname
%python_sitelibdir/PyKF5/*.so
%files -n python-module-%rname-devel
%_datadir/sip/PyKF5/KGuiAddons/
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KGuiAddons/
%endif

%changelog
