%define _unpackaged_files_terminate_build 1

Name: labplot
Version: 2.5.0
Release: alt3

Summary: Function and Data Plotter
License: GPL
Group: Sciences/Other

Url: https://labplot.kde.org/
# git://anongit.kde.org/labplot
Source: %name-%version.tar

BuildRequires(pre): rpm-build-kf5
BuildRequires: ccmake gcc-c++ extra-cmake-modules
BuildRequires: qt5-base-devel qt5-svg-devel 
BuildRequires: kf5-karchive-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel
BuildRequires: kf5-kcoreaddons-devel kf5-kdoctools-devel kf5-ki18n-devel kf5-kiconthemes-devel
BuildRequires: kf5-kdelibs4support-devel kf5-kio-devel kf5-knewstuff-devel kf5-ktextwidgets-devel
BuildRequires: kf5-kwidgetsaddons-devel kf5-kxmlgui-devel
BuildRequires: libXScrnSaver-devel libXau-devel libXcomposite-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXpm-devel libXt-devel
BuildRequires: libXtst-devel libXv-devel libXxf86misc-devel 
BuildRequires: libgsl-devel libhdf5-devel libnetcdf-devel
BuildRequires: libxkbfile-devel xorg-xf86vidmodeproto-devel
BuildRequires: qt5-serialport-devel
BuildRequires: kf5-syntax-highlighting-devel 

Conflicts: labplot1.6
Requires: ImageMagick-tools gsl pstoedit

%description
This is a program for plotting of functions and data manipulation.

A versatile spreadsheet for data import and editing was added.
Also a better 3 dimensional plot with rotation and colormaps is available.
Newly supported are data set operations and image manipulations. One can now
import over 80 different images formats and export directly to ps, eps or pdf.
The plots now use double buffering and LabPlot supports scripting using QSA.

%prep
%setup
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%K5build \
    -DINCLUDE_INSTALL_DIR=%_K5inc \
    -DLIBEXEC_INSTALL_DIR=%_K5exec \
    -DDATA_INSTALL_DIR=%_K5data

%install
%K5install
%find_lang %name --with-kde

%files -f %name.lang
%doc AUTHORS README COPYING ChangeLog
%config(noreplace) %_K5xdgconf/*.knsrc
%_K5bin/*
%_K5data/%{name}2/
%_K5xdgapp/*
%_K5icon/hicolor/*/apps/*
%_K5xmlgui/%{name}2/
%_K5xdgmime/%{name}2.xml
%_K5doc/*/%{name}2/
%_datadir/metainfo/*.xml

%changelog
