Group: Development/C
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: boost-devel pkgconfig(libusb-1.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global majorver 3 

Name: libapogee
Version: 3.1
Release: alt1_4
Summary: Library for Apogee CCD Cameras

License: GPLv2+ and MPLv2.0
URL: http://indilib.org

# Tar is generated from the huge all-in-one tar from INDI
# by using ./libapogee-generate-tarball.sh 1.3.1
Source0: %{name}-%{version}.tar.gz
Source1: %{name}-generate-tarball.sh

BuildRequires:  gcc-c++
BuildRequires: boost-complete ctest cmake libusb-compat-devel libcurl-devel libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
Source44: import.info

%description
Apogee library is used by applications to control Apogee CCDs.

%package devel
Group: Development/C
Summary: Libraries, includes, etc. used to develop an application with %{name}
Requires: %{name} = %{version}-%{release}
%description devel
These are the header files needed to develop a %{name} application

%prep
%setup -q -n %{name}-%{version}
sed -i 's|/lib/udev/rules.d|%{_udevrulesdir}|g' CMakeLists.txt
sed -i 's|DESTINATION lib|DESTINATION lib${LIB_SUFFIX}|g' CMakeLists.txt

%build
%{fedora_cmake}
make VERBOSE=1 %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}



%files
%doc --no-dereference LICENSE
%doc README
%{_libdir}/*.so.*
%{_sysconfdir}/Apogee/*
%{_udevrulesdir}/99-apogee.rules

%files devel
%{_includedir}/*
%{_libdir}/*.so

%changelog
