Name: libcap
Version: 2.27.0.2.ac1e
Release: alt1
Epoch: 1

Summary: Library for getting and setting POSIX.1e capabilities
License: GPL-2.0-only or BSD-3-Clause
Group: System/Libraries
Url: https://sites.google.com/site/fullycapable/
# git://git.altlinux.org/gears/l/libcap.git
Source: %name-%version-%release.tar

# For backwards compatibility.
%{expand:%%define lib_suffix %(test %_lib != lib64 && echo %%nil || echo '()(64bit)')}
Provides: %name.so.1%lib_suffix

BuildRequires: gperf
BuildRequires(pre): libpam-devel

%set_pam_name pam_cap

%package utils
Summary: Utilities for getting and setting POSIX.1e capabilities
Group: System/Base
Requires: %name = %epoch:%version-%release

%package devel
Summary: Development environment for libcap
Group: Development/C
Requires: %name = %epoch:%version-%release

%package -n %pam_name
Summary: PAM module for enforcing inheritable capability sets
Group: System/Base
Provides: pam_cap = %epoch:%version-%release
Obsoletes: pam_cap < %epoch:%version
Requires: %name = %epoch:%version-%release

%description
This is a library for getting and setting POSIX.1e
(formerly POSIX 6) draft 15 capabilities.

%description utils
This packages contains utilities for getting and setting
POSIX.1e (formerly POSIX 6) draft 15 capabilities.

%description devel
The development library, header files, and documentation
for building applications dealing with POSIX.1e
(formerly POSIX 6) draft 15 capabilities.

%description -n %pam_name
The purpose of this PAM module is to enforce inheritable capability sets
for users specified in configuration file.

%prep
%setup -n %name-%version-%release

%build
%make_build CC=%__cc CFLAGS="%optflags" \
	lib=%_lib DEBUG= INDENT= STALIBNAME=

%install
%makeinstall_std lib=%_lib STALIBNAME= RAISE_SETFCAP=no
install -pDm600 pam_cap/capability.conf %buildroot/etc/security/capability.conf

# Relocate development library from /%_lib/ to %_libdir/.
symlink="%buildroot/%_lib/libcap.so"
soname=$(readlink "$symlink")
rm "$symlink"
ln -rsnf %buildroot/%_lib/"$soname" "%buildroot%_libdir/libcap.so"

# For backwards compatibility.
ln -rsnf %buildroot/%_lib/"$soname" "%buildroot%_libdir/libcap.so.1"

%files
/%_lib/*.so.*
%_libdir/*.so.*

%files utils
/sbin/*
%_man1dir/*
%_man8dir/*

%files devel
%_libdir/*.so
%_includedir/sys/*.h
%_pkgconfigdir/*.pc
%_man3dir/*
%doc CHANGELOG License README *.txt pgp.keys.asc doc/capability.notes progs/*.c

%files -n %pam_name
%config(noreplace) /etc/security/capability.conf
%_pam_modules_dir/*

%changelog
