# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
BuildRequires(pre): kernel-build-tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global majorminor 1.0
%global date 20120405
# Avoid to emit gstreamer provides - rhbz#1184975
%undefine __gstreamer1_provides

Summary:       Broadcom Crystal HD device interface library
Name:          libcrystalhd
Version:       3.10.0
Release:       alt3_20
License:       LGPLv2
Group:         System/Libraries
URL:           http://www.broadcom.com/support/crystal-hd/
ExcludeArch:   s390 s390x

#Source:       http://www.broadcom.com/docs/support/crystalhd/crystalhd_linux_20100703.zip
# This tarball and README are inside the above zip file...
# Patch generated from http://git.linuxtv.org/jarod/crystalhd.git
Source0:       libcrystalhd-%{date}.tar.bz2
Source1:       README_07032010
# We're going to use even newer firmware for now
Source2:       bcm70012fw.bin
Source3:       bcm70015fw.bin
# LICENSE file is copy-n-pasted from http://www.broadcom.com/support/crystal_hd/
Source4:       LICENSE
Source5:       libcrystalhd-snapshot.sh
Patch0:        libcrystalhd-nosse2.patch
# https://patchwork2.kernel.org/patch/2247431/
Patch1:        crystalhd-gst-Port-to-GStreamer-1.0-API.patch

BuildRequires: gcc-c++
BuildRequires: autoconf automake libtool
BuildRequires: gstreamer1.0-devel libgstreamer1.0-gir-devel
BuildRequires: gst-plugins1.0-devel gst-plugins1.0-gir-devel
Requires:      firmware-crystalhd
Source44: import.info
Patch33: libcrystalhd-alt-from-zerg-bug30916.patch

%description
The libcrystalhd library provides userspace access to Broadcom Crystal HD
video decoder devices. The device supports hardware decoding of MPEG-2,
h.264 and VC1 video codecs, up to 1080p at 40fps for the first-generation
bcm970012 hardware, and up to 1080p at 60fps for the second-generation
bcm970015 hardware.

%package devel
Summary:       Development libs for libcrystalhd
Group:         Development/Other
Requires:      %{name} = %{version}-%{release}

%description devel
Development libraries needed to build applications against libcrystalhd.

%package -n firmware-crystalhd
Summary:       Firmware for the Broadcom Crystal HD video decoder
License:       Redistributable, no modification permitted
BuildArch:     noarch
Group:         System/Kernel and hardware
Requires:      %{name} = %{version}-%{release}

%description -n firmware-crystalhd
Firmwares for the Broadcom Crystal HD (bcm970012 and bcm970015)
video decoders.

%package -n gstreamer-plugin-crystalhd
Summary:       Gstreamer crystalhd decoder plugin
Group:         Sound
Requires:      %{name} = %{version}-%{release}
Requires:      gst-plugins-base1.0

%description -n gstreamer-plugin-crystalhd
Gstreamer crystalhd decoder plugin

%package -n kernel-source-crystalhd
Summary: Linux crystalhd  Broadcom module sources
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-crystalhd
Crystalhd module sources for Linux kernel.


%prep
%setup -q -n libcrystalhd-%{date}
cp %{SOURCE1} %{SOURCE4} .
%ifnarch %{ix86} ia64 x86_64
%patch0 -p1 -b .nosse2
sed -i -e 's|-msse2||' linux_lib/libcrystalhd/Makefile
%endif
%patch1 -p1 -b .gst1
%patch33 -p1

%build
pushd linux_lib/libcrystalhd/ > /dev/null 2>&1
sed -i -e 's|-D__LINUX_USER__|-D__LINUX_USER__ %{optflags}|' Makefile
%{make_build}
popd > /dev/null 2>&1

pushd filters/gst/gst-plugin/ > /dev/null 2>&1
sh autogen.sh || :

%configure
%make_build \
  CFLAGS="%{optflags} -I%{_builddir}/%{buildsubdir}/include -I%{_builddir}/%{buildsubdir}/linux_lib/libcrystalhd" \
  BCMDEC_LDFLAGS="%{?__global_ldflags} -L%{_builddir}/%{buildsubdir}/linux_lib/libcrystalhd -lcrystalhd"
popd > /dev/null 2>&1

%install
pushd linux_lib/libcrystalhd/ > /dev/null 2>&1
make install LIBDIR=%{_libdir} DESTDIR=$RPM_BUILD_ROOT
popd > /dev/null 2>&1

pushd filters/gst/gst-plugin/ > /dev/null 2>&1
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{_libdir}/gstreamer-1.0/libgstbcmdec.{a,la}
popd > /dev/null 2>&1

rm -rf $RPM_BUILD_ROOT/lib/firmware/
mkdir -p $RPM_BUILD_ROOT/lib/firmware/
install -pm 0644 %{SOURCE2} $RPM_BUILD_ROOT/lib/firmware/
install -pm 0644 %{SOURCE3} $RPM_BUILD_ROOT/lib/firmware/

#Install udev rule
mkdir -p $RPM_BUILD_ROOT%{_udevrulesdir}
install -pm 0644 driver/linux/20-crystalhd.rules \
  $RPM_BUILD_ROOT%{_udevrulesdir}

mv driver kernel-source-crystalhd-%version
mkdir -p %kernel_srcdir/
tar jcf %kernel_srcdir/kernel-source-crystalhd-%version.tar.bz2 kernel-source-crystalhd-%version/



%files
%doc README_07032010 LICENSE
%{_libdir}/libcrystalhd.so.*

%files devel
%dir %{_includedir}/libcrystalhd
%{_includedir}/libcrystalhd/*
%{_libdir}/libcrystalhd.so

%files -n firmware-crystalhd
%doc LICENSE
%{_udevrulesdir}/20-crystalhd.rules
/lib/firmware/bcm70012fw.bin
/lib/firmware/bcm70015fw.bin

%files -n gstreamer-plugin-crystalhd
%{_libdir}/gstreamer-%{majorminor}/*.so

%files -n kernel-source-crystalhd
/usr/src/kernel/sources/*



%changelog
