# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(glib-2.0)
# END SourceDeps(oneline)
Group: Development/Other
%add_optflags %optflags_shared
%define oldname eris
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           liberis
Version:        1.3.23
Release:        alt2_15
Summary:        Client-side session layer for Atlas-C++

# All files untagged except for Eris/Operations.{cpp,h} which is labeled
# LGPL with no version.
License:        LGPLv2+
URL:            http://worldforge.org/dev/eng/libraries/eris
Source0:        http://downloads.sourceforge.net/worldforge/%{oldname}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires: libmercator-devel doxygen
BuildRequires: libatlascpp-devel >= 0.5.98
BuildRequires: libwfmath-devel >= 0.3.2
BuildRequires: libskstream-devel >= 0.3.5

BuildRequires:  libsigc++2-devel
Source44: import.info
Provides: eris = %{version}-%{release}

%description
A client side session layer for WorldForge; Eris manages much of the generic
work required to communicate with an Atlas server. Client developers can extend
Eris in a number of ways to rapidly add game and client specific functions, and
quickly tie game objects to whatever output representation they are using.


%package devel
Group: Development/Other
Summary:        Development files for Eris
Requires:       %{name} = %{version}-%{release}
Provides: eris-devel = %{version}-%{release}


%description devel
Libraries and header files for developing applications that use Eris.


%prep
%setup -n %{oldname}-%{version} -q


%build
%configure
%make_build

%install
%makeinstall_std

rm -f $RPM_BUILD_ROOT%{_libdir}/lib%{oldname}-1.3.la

# 2014-05-17 - Tests disabled because one of 42 failed, will work w/ upstream to fix
%check
# Run tests in debug mode so asserts won't be skipped
#sed -i -e 's/-DNDEBUG/-DDEBUG/' test/Makefile
#make %{?_smp_mflags} check





%files
%doc AUTHORS ChangeLog CHANGES-1.4 COPYING NEWS README TODO
%{_libdir}/lib%{oldname}-1.3.so.*


%files devel
%{_includedir}/Eris-1.3
%{_libdir}/lib%{oldname}-1.3.so
%{_libdir}/pkgconfig/*.pc


%changelog
