%def_disable snapshot
%def_enable ffmpeg
# test_rpm failed
%def_disable check

Name: libextractor
Version: 1.10
Release: alt1

Summary: libextractor is a simple library for keyword extraction

Group: System/Libraries
License: GPLv2+
Url: http://www.gnu.org/software/%name/

%if_disabled snapshot
Source: ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define flac_ver 1.3

BuildRequires: gcc-c++ zlib-devel bzlib-devel glib2-devel libexiv2-devel libflac-devel >= %flac_ver
BuildRequires: libgsf-devel libltdl7-devel libgtk+3-devel
BuildRequires: libmpeg2-devel libtiff-devel libmp4v2-devel libqt4-devel librpm-devel
BuildRequires: libopus-devel libvorbis-devel libflac-devel
BuildRequires: iso-codes-devel libgif-devel libarchive-devel libtidy-devel
BuildRequires: libjpeg-devel gst-plugins1.0-devel
%if_enabled ffmpeg
BuildRequires: libavcodec-devel libavutil-devel
BuildRequires: libavformat-devel libavresample-devel libswscale-devel
%endif
BuildRequires: makeinfo

%description
libextractor is a simple library for keyword extraction.
libextractor does not support all formats but supports a simple plugging
mechanism such that you can quickly add extractors for additional
formats, even without recompiling libextractor. libextractor typically
ships with a dozen helper-libraries that can be used to obtain keywords
from common file-types.

%package -n extract
Summary: extract is a simple command-line interface to libextractor
Group: File tools
Requires: %name = %version-%release

%description -n extract
libextractor is a simple library for keyword extraction.
This package privides the extract is a simple command-line interface to
libextractor.

%package devel
Summary: %name development files and libraries
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the files needed to build packages that depend on %name.

%prep
%setup

%build
%autoreconf
%configure --disable-static \
	%{subst_enable ffmpeg}
%make_build

%install
%makeinstall_std

# remove non-packaged files
rm -f %buildroot%_libdir/%name/*.la

%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
export LIBEXTRACTOR_PREFIX=%buildroot%_libdir
# some tests failed in hasher -- need to investigate
%make check

%files -f %name.lang
%_libdir/*.so.*
%dir %_libdir/%name
%_libdir/%name/*.so
%doc AUTHORS README NEWS TODO

%files -n extract
%_bindir/extract
%_man1dir/*

%files devel
%_includedir/*
%_infodir/*
%_pkgconfigdir/*
%_libdir/*.so
%_man3dir/*

%changelog
