%def_disable snapshot

%define _name gdk-pixbuf
%define api_ver 2.0
%define binary_ver 2.10.0
%define ver_major 2.38
%define _libexecdir %_prefix/libexec

%def_enable gtk_doc
%def_enable man
%def_enable introspection
%def_enable x11
%def_enable libjasper
%def_enable installed_tests
%def_enable check

Name: lib%_name
Version: %ver_major.2
Release: alt1

Summary: An image loading and rendering library for Gdk
Group: System/Libraries
License: LGPL
Url: http://www.gtk.org

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: %_name-2.37.92-alt-compat-version-script.patch
Patch1: %_name-2.38.1-alt-tests_timeouts.patch

Source1: %_name.map
Source2: %_name.lds

%define glib_ver 2.48.0
%define gi_ver 0.9.5

Requires: %name-locales = %version

Provides: %name-loaders = %version
Obsoletes: %name-loaders <= %version

BuildRequires(pre): meson rpm-build-gir
BuildRequires: /proc libgio-devel >= %glib_ver
BuildRequires: libjpeg-devel libpng-devel libtiff-devel
BuildRequires: docbook-utils gtk-doc
%{?_enable_x11:BuildRequires: libX11-devel}
%{?_enable_libjasper:BuildRequires: libjasper-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}

%description
The GdkPixBuf library provides a number of features:
+ Image loading facilities.
+ Rendering of a GdkPixBuf into various formats:
  drawables (windows, pixmaps), GdkRGB buffers.

%package xlib
Summary: An image loading and rendering library for Gdk
Group: System/Libraries
Requires: %name = %version-%release

%description xlib
The GdkPixBuf library provides a number of features:
+ Image loading facilities.
+ Rendering of a GdkPixBuf into various formats:
  drawables (windows, pixmaps), GdkRGB buffers.

This package provides Xlib version of %name.

%package locales
Summary: Internationalization for GdkPixBuf library
Group: System/Internationalization
Conflicts: %name < %version-%release
BuildArch: noarch

%description locales
This package provides internationalization support for GdkPixBuf,
an image loading and rendering library for Gdk.

%package devel
Summary: Development files for GdkPixBuf applications
Group: Development/C
Requires: %name = %version-%release
Requires: %name-xlib = %version-%release

%description devel
GdkPixBuf is an image loading and rendering library for Gdk.

This package provides include files needed for developing GdkPixBuf
applications.

%package devel-doc
Summary: Development documentation for GdkPixBuf library
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
GdkPixBuf is an image loading and rendering library for Gdk.

This package provides documentation needed for developing GdkPixBuf
applications.

%package gir
Summary: GObject introspection data for the GdkPixBuf library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GdkPixBuf library

%package gir-devel
Summary: GObject introspection devel data for the GdkPixBuf library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GdkPixBuf library

%package tests
Summary: Tests for the GdkPixBuf library
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed GdkPixBuf library.


%prep
%setup -n %_name-%version
%patch -p1 -b .alt
%patch1 -b .timeout

install -p -m644 %_sourcedir/%_name.map %_name/compat.map
install -p -m644 %_sourcedir/%_name.lds %_name/compat.lds

%build
%ifarch %e2k
# till lcc ~1.23
export LIBS=-lcxa
%endif
%meson \
	%{?_enable_gtk_doc:-Ddocs=true} \
	%{?_enable_man:-Dman=true} \
	%{?_enable_introspection:-Dgir=true} \
	%{?_enable_x11:-Dx11=true} \
	%{?_enable_libjasper:-Djasper=true} \
	%{?_disable_installed_tests:-Dinstalled_tests=false} \
	-Dbuiltin_loaders='png'

%meson_build

%install
%meson_install

ln %buildroot%_bindir/%_name-query-loaders %buildroot%_libdir/%_name-%api_ver/%binary_ver/

# rpm posttrans filetriggers
mkdir -p %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/gdk-pixbuf-loaders.filetrigger << '@@@'
#!/bin/sh -efu

LC_ALL=C sed -rn 's|(^/usr/lib(64)?)/gdk-pixbuf.*/loaders/.*|\1|p' | sort -u | while read L; do
       if [ -x "$L/%_name-%api_ver/%binary_ver/%_name-query-loaders" ]; then
              $L/%_name-%api_ver/%binary_ver/%_name-query-loaders --update-cache
       fi
done
@@@
chmod 755 %buildroot%_rpmlibdir/gdk-pixbuf-loaders.filetrigger
touch %buildroot%_libdir/%_name-%api_ver/%binary_ver/loaders.cache

%find_lang %_name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_bindir/gdk-pixbuf-query-loaders
%_bindir/gdk-pixbuf-thumbnailer
%_libdir/libgdk_pixbuf-2.0.so.*
%dir %_libdir/%_name-%api_ver
%dir %_libdir/%_name-%api_ver/%binary_ver
%dir %_libdir/%_name-%api_ver/%binary_ver/loaders
%_libdir/%_name-%api_ver/%binary_ver/%_name-query-loaders
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-ani.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-bmp.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-gif.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-icns.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-ico.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-jpeg.so
#%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-png.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-pnm.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-qtif.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-tga.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-tiff.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-xbm.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-xpm.so
%{?_enable_libjasper:%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-jasper.so}
%ghost %_libdir/%_name-%api_ver/%binary_ver/loaders.cache
%_datadir/thumbnailers/gdk-pixbuf-thumbnailer.thumbnailer
%_man1dir/gdk-pixbuf-query-loaders*
%_rpmlibdir/gdk-pixbuf-loaders.filetrigger

%if_enabled x11
%files xlib
%_libdir/libgdk_pixbuf_xlib-2.0.so.*
%endif
%doc NEWS README.md

%files locales -f %_name.lang

%files devel
%_bindir/gdk-pixbuf-csource
%_bindir/%_name-pixdata
%_libdir/*.so
%dir %_includedir/%_name-%api_ver
%_includedir/%_name-%api_ver/%_name
%_pkgconfigdir/%_name-%api_ver.pc
%if_enabled x11
%_includedir/%_name-%api_ver/%_name-xlib
%_pkgconfigdir/%_name-xlib-%api_ver.pc
%endif
%_man1dir/gdk-pixbuf-csource*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/GdkPixbuf-%api_ver.typelib
%_typelibdir/GdkPixdata-%api_ver.typelib

%files gir-devel
%_girdir/GdkPixbuf-%api_ver.gir
%_girdir/GdkPixdata-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
