%define rname gegl
%define api_ver 0.4

Name: lib%rname
Version: %api_ver.22
Release: alt1
Summary: A graph based image processing framework
License: %gpllgpl3plus
Group: System/Libraries
Url: http://www.gimp.org

Source: %rname-%version.tar
Patch: %rname-%version-alt.patch

BuildRequires(pre): rpm-build-licenses meson
BuildRequires: asciidoc enscript gcc-c++ graphviz gtk-doc libSDL-devel libavformat-devel libbabl-devel libexiv2-devel
BuildRequires: libgexiv2-devel libgomp-devel libgtk+3-devel libjasper-devel libjpeg-devel libjson-glib-devel
BuildRequires: libpoly2tri-c-devel libraw-devel librsvg-devel libspiro-devel libsuitesparse-devel libswscale-devel
BuildRequires: libtiff-devel libv4l-devel libwebp-devel openexr-devel ruby vala-tools gobject-introspection-devel w3m
BuildRequires: python-module-pygobject3-common-devel libpoppler-glib-devel libspiro-devel liblua-devel libSDL2-devel
%ifarch %arm aarch64 %ix86 x86_64
BuildRequires: libluajit-devel
%endif

%description
GEGL (Generic Graphics Library) is a graph based image processing framework.
GEGLs original design was made to scratch GIMPs itches for a new
compositing and processing core. This core is being designed to have
minimal dependencies. and a simple well defined API.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name = %version-%release
Provides: %name-gir-devel = %version-%release
Obsoletes: %name-gir-devel < %version-%release

%description devel
This package contains the libraries and header files needed for
developing with %name.

%package gir
Summary: GObject introspection data for the GEGL
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GEGL library.

%prep
%setup -n %rname-%version
%patch -p1

%build
%meson \
	-Ddocs=false
%meson_build -v

%install
%meson_install

rm -f %buildroot%_libdir/%rname-%api_ver/*.la

%find_lang %rname-%api_ver

%files -f %rname-%api_ver.lang
%_bindir/%rname
%_bindir/%rname-imgcmp
%_libdir/%name-%api_ver.so.*
%_libdir/%name-sc-%api_ver.so
%_libdir/%name-npd-%api_ver.so
%dir %_libdir/%rname-%api_ver
%_libdir/%rname-%api_ver/*.so
%_libdir/%rname-%api_ver/grey2.json
%ifarch %arm aarch64 %ix86 x86_64
%_datadir/%rname-%api_ver
%endif

%files devel
%_includedir/%rname-%api_ver
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%rname-%api_ver.pc
%_pkgconfigdir/%rname-sc-%api_ver.pc
%_vapidir/%rname-%api_ver.deps
%_vapidir/%rname-%api_ver.vapi
%_girdir/Gegl-%api_ver.gir

%files gir
%_typelibdir/Gegl-%api_ver.typelib

%changelog
