%def_disable snapshot

%define _libexecdir %prefix/libexec
%define ver_major 1.56
%define _name gjs
%define api_ver 1.0
%define mozjs_ver_major 60

%def_disable check
%def_enable installed_tests

Name: lib%_name
Version: %ver_major.2
Release: alt1

Summary: Javascript Bindings for GNOME
Group: System/Libraries
# The following files contain code from Mozilla which
# is triple licensed under MPL1.1/LGPLv2+/GPLv2+:
# The console module (modules/console.c)
# Stack printer (gjs/stack.c)
License: MIT and (MPLv1.1 or GPLv2+ or LGPLv2+)
Url: https://wiki.gnome.org/action/show/Projects/Gjs

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif

%define glib_ver 2.54.0
%define gi_ver 1.53.4

Requires: gobject-introspection

BuildRequires(pre): rpm-build-gir
BuildRequires: gnome-common gcc-c++ libffi-devel libcairo-devel
BuildRequires: libmozjs%mozjs_ver_major-devel
BuildRequires: libgio-devel >= %glib_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libreadline-devel libcairo-gobject-devel
BuildRequires: libgtk+3-devel libgtk+3-gir-devel
BuildRequires: valgrind
# for check
BuildRequires: /proc dbus-tools dbus-tools-gui

%description
Gjs allows using GNOME libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release
Requires: /proc

%description devel
Files for development with %name.

%package tests
Summary: Tests for the Gjs package
Group: Development/Other
Requires: %name = %version-%release
%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Gjs library package.

%set_typelibdir %_libdir/%_name/girepository-1.0

%prep
%setup -n %_name-%version

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
    --disable-static \
    %{?_enable_installed_tests:--enable-installed-tests}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/%name.so.*
%dir %_libdir/%_name/
%dir %_typelibdir
%_typelibdir/GjsPrivate-1.0.typelib
%dir %_datadir/%_name-%api_ver
%doc COPYING NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name.so
%_pkgconfigdir/%_name-%api_ver.pc
%_datadir/%_name-%api_ver/lsan/
%_datadir/%_name-%api_ver/valgrind/
%doc examples/*

%if_enabled installed_tests
%add_typelib_req_skiplist typelib(GIMarshallingTests) typelib(Regress) typelib(WarnLib)

%files tests
%_libdir/%_name/libgimarshallingtests.so
%_libdir/%_name/libregress.so
%_libdir/%_name/libwarnlib.so
%_libexecdir/%_name/installed-tests/
%_datadir/installed-tests/%_name/

%exclude %_libdir/%_name/*.la
%endif


%changelog
