%def_enable static

Name: libgpg-error
Version: 1.36
Release: alt1

Group: System/Libraries
Summary: Error library for GnuPG and related projects
License: LGPL
URL: http://www.gnupg.org/

Packager: Sergey V Turchin <zerg@altlinux.org>

Source: %name-%version.tar.bz2

BuildRequires: glibc-devel
%if_enabled static
BuildRequires: glibc-devel-static
%endif
# explicitly added texinfo for info files
BuildRequires: texinfo

%package devel
Summary: Development files for the %name package
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static libraries for the %name-devel package
Group: Development/C
Requires: %name-devel = %version-%release

%description
This is a library that defines common error values for all GnuPG
components.  Among these are GPG, GPGSM, GPGME, GPG-Agent, libgcrypt,
pinentry, SmartCard Daemon and possibly more in the future.

%description devel
This package contains files needed to develop
applications using the GnuPG error library.

%description devel-static
Static build of the GnuPG error library.

%prep
%setup -q

%build
%autoreconf
%configure %{subst_enable static} --disable-rpath
%make_build

%install
%makeinstall

# relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
mv -f %buildroot%_libdir/libgpg-error.so.* %buildroot/%_lib
ln -sf ../../%_lib/libgpg-error.so.0 %buildroot%_libdir/libgpg-error.so

%find_lang %name

%check
%make check

%define _unpackaged_files_terminate_build 1

%files -f %name.lang
/%_lib/lib*.so.*
%_bindir/gpg-error
%_datadir/libgpg-error/
%doc AUTHORS ChangeLog NEWS README

%files devel
%_bindir/*-config
%_bindir/yat2m
%_libdir/*.so
%_includedir/*
%_datadir/aclocal/*
%_man1dir/gpgrt-config.1.*
%_infodir/gpgrt.*
%_pkgconfigdir/*.pc
%_datadir/common-lisp/source/gpg-error

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
