%def_enable snapshot

%define _name gupnp
%define ver_major 1.0
%def_disable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable check

Name: libgupnp
Version: %ver_major.4
Release: alt1

Summary: A framework for creating UPnP devices and control points
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

BuildRequires(pre): meson
BuildRequires: libgssdp-devel >= 0.14.16 libgio-devel >= 2.40.0
BuildRequires: libxml2-devel libsoup-devel >= 2.48 libuuid-devel gtk-doc
BuildRequires: vala-tools rpm-build-vala libvala-devel >= 0.22
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libsoup-gir-devel libgssdp-gir-devel}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%package devel
Summary: Development files and libraries for gUPnP
Group: Development/C
Requires: %name = %version-%release

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides files for development with gUPnP.

%package devel-doc
Summary: Development documentaion for gUPnP
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides development documentations for gUPnP.

%package gir
Summary: GObject introspection data for the gUPnP library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the gUPnP library

%package gir-devel
Summary: GObject introspection devel data for the gUPnP library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the gUPnP library


%prep
%setup -n %_name-%version

%build
%meson \
%{?_enable_gtk_doc:-Dgtk_doc=true} \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_vala:-Dvapi=false}

%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_libdir/*.so.*
%_bindir/gupnp-binding-tool
%doc AUTHORS README ChangeLog

%files devel
%_pkgconfigdir/*.pc
%_libdir/*.so
%_includedir/*
%if_enabled vala
%_vapidir/*.deps
%_vapidir/*.vapi
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif


%changelog
