%def_disable snapshot

%define _name harfbuzz
%define ver_major 2.8
%def_with graphite2
%def_with icu
%def_with gobject
%def_enable introspection
%def_enable gtk_doc

%ifnarch armh
%def_enable check
%endif

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: HarfBuzz is an OpenType text shaping engine
Group: System/Libraries
License: MIT
Url: http://harfbuzz.org/

%if_disabled snapshot
Source: https://github.com/%_name/%_name/archive/%version/%_name-%version.tar.gz
%else
Vcs: https://github.com/harfbuzz/harfbuzz.git
Source: %_name-%version.tar
%endif

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: gtk-doc gcc-c++ glib2-devel libfreetype-devel libcairo-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_with_graphite2:BuildRequires: libgraphite2-devel}
%{?_with_icu:BuildRequires: libicu-devel}
%{?_enable_check:BuildRequires: python3-test fonttools}

%description
HarfBuzz is an implementation of the OpenType Layout engine.
This package provides shared HarfBuzz library.

%package icu
Summary: Shared HarfBuzz library with ICU support.
Group: System/Libraries
Requires: %name = %version-%release

%description icu
HarfBuzz is an implementation of the OpenType Layout engine.
This package provides shared HarfBuzz library with ICU support.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
%{?_with_icu:Requires: %name-icu = %version-%release}
%{?_with_gobject:Requires: %name-gobject = %version-%release}

%description devel
The %name-devel package contains files for developing applications that
use HarfBuzz library.

%package gobject
Summary: GObject bindings for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gobject
This package contains functionality to make HarfBuzz library
integrate well with the GObject object system used by GNOME.

%package devel-doc
Summary: Development documentation for Pango
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
HarfBuzz is an implementation of the OpenType Layout engine.
This package contains development documentation for HarfBuzz.

%package utils
Summary: Utilities from HarfBuzz project
Group: Development/Tools
Requires: %name = %version-%release

%description utils
The %name-utils package provides utilities from %name package.

%package gir
Summary: GObject introspection data for the HarfBuzz library
Group: System/Libraries
Requires: %name-gobject = %version-%release

%description gir
GObject introspection data for the HarfBuzz library

%package gir-devel
Summary: GObject introspection devel data for the HarfBuzz library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the HarfBuzz library

%prep
%setup -n %_name-%version

%build
export PYTHON=%__python3
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static \
	--with-glib \
	--with-freetype \
	--with-cairo \
	%{subst_with icu} \
	%{subst_with graphite2} \
        %{subst_with gobject} \
        %{subst_enable introspection} \
	%{?_enable_gtk_doc:--enable-gtk-doc}
%nil
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/%name.so.*
%_libdir/%name-subset.so.*

%files devel
%_includedir/%_name/
%_libdir/%name.so
%_libdir/%name-subset.so
%if_with icu
%_libdir/%name-icu.so
%endif
%_pkgconfigdir/%_name.pc
%_pkgconfigdir/%_name-icu.pc
%_pkgconfigdir/%_name-subset.pc
%_libdir/cmake/%_name/
%doc NEWS AUTHORS COPYING README
%if_with gobject
%_libdir/%name-gobject.so
%_pkgconfigdir/%_name-gobject.pc
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_with icu
%files icu
%_libdir/%name-icu.so.*
%endif

%files utils
%_bindir/hb-view
%_bindir/hb-ot-shape-closure
%_bindir/hb-shape
%_bindir/hb-subset

%if_with gobject
%files gobject
%_libdir/%name-gobject.so.*
%endif

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif

%changelog
