%filter_from_requires /^python2.7.haru/d
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
BuildRequires: python-modules-encodings
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global gittag0 RELEASE_2_3_0

Name:           libharu
Version:        2.3.0
Release:        alt2_3
Summary:        C library for generating PDF files
License:        zlib with acknowledgement
URL:            http://libharu.org
Source0:        https://github.com/libharu/${name}/archive/%{gittag0}/%{name}-%{version}.tar.gz
Patch0:         libharu-RELEASE_2_3_0_cmake.patch

# Based on patches from Gentoo
Patch10: libharu-2.3.0-1-Included-necessary-char-widths-in-generated-PDF.patch
Patch11: libharu-2.3.0-2-Avoid-issue-with-libtiff-duplicate-symbols.patch
Patch12: libharu-2.3.0-3-cmake-fixes.patch
Patch13: libharu-2.3.0-4-Add-support-for-free-form-triangle-Shading-objects.patch

BuildRequires:  gcc-common
BuildRequires:  ctest cmake
BuildRequires:  libpng-devel
BuildRequires:  zlib-devel
Source44: import.info

%description
libHaru is a library for generating PDF files. 
It is free, open source, written in ANSI C and cross platform.

%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -qn %{name}-%{gittag0}
# fix cmake build
%patch0 -p1 -b .cmake

%patch10 -p1
%patch11 -p1
%patch12 -p2
%patch13 -p1

%build
mkdir -p %{_target_platform}
pushd %{_target_platform}
%{fedora_cmake} -DLIBHPDF_STATIC=NO ..
popd

%make_build -C %{_target_platform}

%install
make install/fast -C %{_target_platform}  DESTDIR=%{buildroot}

%files
%doc README
%{_libdir}/libhpdf.so.*
%_defaultdocdir/%{name}

%files devel
%{_includedir}/*
%{_libdir}/libhpdf.so

%changelog
