%define _unpackaged_files_terminate_build 1
%def_with check

%ifarch %arm %ix86 mips mipsel
%def_without mdb
%else
%def_with mdb
%endif

Name: libldb
Version: 2.3.2
Release: alt1
Summary: A schema-less, ldap like, API and database
License: LGPLv3+
Group: System/Libraries
Url: http://ldb.samba.org/

Source: http://samba.org/ftp/ldb/ldb-%{version}.tar.gz
Patch: ldb-samba-modules.patch
Patch1: ldb-alt-fix-python-ldflags.patch
Patch2: ldb-skip-test_guid_indexed_v1_db-on-mips64el-ppc64le-mipsel.patch
Patch3: ldb-skip-ldb_lmdb_free_list_test-on-ppc64le.patch
Patch4: ldb-pyldb-overflow-timestring-test-32bit.patch

BuildRequires: libpopt-devel libldap-devel xsltproc docbook-style-xsl docbook-dtds
BuildRequires: libcmocka-devel >= 1.1.3
BuildRequires: socket_wrapper >= 1.3.3
BuildRequires: nss_wrapper >= 1.1.11
BuildRequires: resolv_wrapper >= 1.1.7
BuildRequires: uid_wrapper >= 1.2.7
BuildRequires: pam_wrapper >= 1.1.2
BuildRequires: libtdb-devel >= 1.4.3
BuildRequires: libtalloc-devel >= 2.3.2
BuildRequires: libtevent-devel >= 0.10.2
%if_with mdb
BuildRequires: liblmdb-devel >= 0.9.16
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-tdb
BuildRequires: python3-module-talloc-devel
BuildRequires: python3-module-tevent

Requires: libtdb >= 1.4.3
Requires: libtalloc >= 2.3.2
Requires: libtevent >= 0.10.2
%if_with mdb
Requires: liblmdb >= 0.9.16
%endif

%description
An extensible library that implements and LDAP like API to access remote LDAP
servers, or use local tdb databases.

%package devel
Group: Development/C
Summary: Developer tools for the LDB library
Requires: %name = %EVR

%description devel
Header files needed to develop programs that link against the LDB library.

%package -n ldb-tools
Group: Development/Tools
Summary: Tools to manage LDB files
Requires: %name = %EVR

%description -n ldb-tools
Tools to manage LDB files

%package -n python3-module-pyldb
Group: Development/Python3
Summary: Python3 bindings for the LDB library
Requires: %name = %EVR

%description -n python3-module-pyldb
Python3 bindings for the LDB library

%package -n python3-module-pyldb-devel
Group: Development/Python3
Summary: Development files for the Python3 bindings for the LDB library
Requires: python3-module-pyldb = %EVR
Requires: %name-devel = %EVR

%description -n python3-module-pyldb-devel
Development files for the Python3 bindings for the LDB library

%prep
%setup -n ldb-%version
%patch -p2
%patch1 -p1
%patch2 -p1
%ifarch ppc64le
%patch3 -p2
%endif
%ifarch %ix86 %arm %mips32
%patch4 -p2
%endif

%build
%undefine _configure_gettext
%configure	\
		--disable-rpath \
		--disable-rpath-install \
		--bundled-libraries=NONE \
		--builtin-libraries=replace \
		--with-modulesdir=%_libdir/ldb/modules \
		--with-samba-modulesdir=%_libdir/samba \
%if_without mdb
                --without-ldb-lmdb \
%endif
		--with-privatelibdir=%_libdir/ldb
%make

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a
rm -f %buildroot/%_man3dir/_*

%check
make test

%files
%_libdir/libldb.so.*
%dir %_libdir/ldb
%dir %_libdir/ldb/modules
%dir %_libdir/ldb/modules/ldb

%_libdir/ldb/libldb-key-value.so
%if_with mdb
%_libdir/ldb/libldb-mdb-int.so
%endif
%_libdir/ldb/libldb-tdb-int.so
%_libdir/ldb/libldb-tdb-err-map.so

%_libdir/ldb/modules/ldb/asq.so
%_libdir/ldb/modules/ldb/ldap.so
%_libdir/ldb/modules/ldb/paged_searches.so
%_libdir/ldb/modules/ldb/rdn_name.so
%_libdir/ldb/modules/ldb/sample.so
%_libdir/ldb/modules/ldb/server_sort.so
%_libdir/ldb/modules/ldb/skel.so
%_libdir/ldb/modules/ldb/tdb.so
%_libdir/ldb/modules/ldb/ldb.so
%if_with mdb
%_libdir/ldb/modules/ldb/mdb.so
%endif

%files devel
%_includedir/ldb.h
%_includedir/ldb_errors.h
%_includedir/ldb_handlers.h
%_includedir/ldb_module.h
%_includedir/ldb_version.h
%_libdir/libldb.so
%_pkgconfigdir/ldb.pc
%_man3dir/ldb.3.*

%files -n ldb-tools
%_bindir/ldbadd
%_bindir/ldbdel
%_bindir/ldbedit
%_bindir/ldbmodify
%_bindir/ldbrename
%_bindir/ldbsearch
%_man1dir/ldbadd.1.*
%_man1dir/ldbdel.1.*
%_man1dir/ldbedit.1.*
%_man1dir/ldbmodify.1.*
%_man1dir/ldbrename.1.*
%_man1dir/ldbsearch.1.*
%_libdir/ldb/libldb-cmdline.so

%files -n python3-module-pyldb
%python3_sitelibdir/ldb.cpython-*.so
%python3_sitelibdir/_ldb_text.py
%python3_sitelibdir/__pycache__/_ldb_text.cpython-*.py*
%_libdir/libpyldb-util.cpython-*.so.*

%files -n python3-module-pyldb-devel
%_includedir/pyldb.h
%_libdir/libpyldb-util.cpython-*.so
%_pkgconfigdir/pyldb-util.cpython-*.pc

%changelog
