# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libpgf
Version:        6.14.12
Release:        alt1_10
Summary:        PGF (Progressive Graphics File) library

License:        LGPLv2+
URL:            http://www.libpgf.org
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-src-%{version}.tar.gz
# Modernize automake usage
Patch0:         libpgf-auto.patch

## backport upstream fixes
Patch147: libpgf-r147.patch
Patch148: libpgf-r148.patch

BuildRequires:  doxygen
BuildRequires:  gcc-c++
BuildRequires:  libtool
Source44: import.info

%description
libPGF contains an implementation of the Progressive Graphics File (PGF)
which is a new image file format, that is based on a discrete, fast
wavelet transform with progressive coding features. PGF can be used
for lossless and lossy compression.

%package        devel
Group: System/Libraries
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q -n %{name}
%patch0 -p1 -b .auto
%patch147 -p1 -b .r147
%patch148 -p1 -b .r148
# Fix line endings
sed -i -e 's/\r//' configure.ac README

sed -i 's|$(DESTDIR)$(datadir)/doc/$(DOC_MODULE)|$(RPM_BUILD_DIR)/libpgf|g' doc/Makefile.am

sh autogen.sh


%build
# FIXME/TODO: document need for -DLIBPGF_DISABLE_OPENMP
# commit 52c998909401f404f1c7029b537ec900f3f780d0 doesn't say why, but
# I *think* it's related to digikam -- rex
export CFLAGS="%{optflags} -DLIBPGF_DISABLE_OPENMP"
export CXXFLAGS="%{optflags} -DLIBPGF_DISABLE_OPENMP"

%configure --disable-static

%make_build


%install
%makeinstall_std

# unpackaged files
rm -fv %{buildroot}%{_libdir}/libpgf.la




%files
%doc README
%doc --no-dereference COPYING
%{_libdir}/libpgf.so.6*

%files devel
%doc html
%{_includedir}/libpgf/
%{_libdir}/libpgf.so
%{_libdir}/pkgconfig/libpgf.pc
%{_mandir}/man3/*.3*


%changelog
